package io.github.fishstiz.cursors_extended.mixin.cursorprovider;

import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.class_11875;
import net.minecraft.class_7528;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(class_7528.class)
public abstract class AbstractScrollAreaMixin {
    @ModifyArg(method = "renderScrollbar", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/GuiGraphics;requestCursor(Lcom/mojang/blaze3d/platform/cursor/CursorType;)V"
    ))
    private class_11875 holdResizeNs(class_11875 cursorType) {
        return CursorTypeUtil.applyScrollbarConfig(cursorType);
    }
}
