package io.github.fishstiz.cursors_extended.mixin.cursorprovider.menus;

import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.mixin.cursorprovider.menus.access.RecipeAlternativesWidgetAccessor;
import io.github.fishstiz.cursors_extended.mixin.cursorprovider.menus.access.RecipeBookResultsAccessor;
import io.github.fishstiz.cursors_extended.mixin.cursorprovider.menus.access.RecipeBookWidgetAccessor;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.class_10260;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_1729;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_507;
import net.minecraft.class_508;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_10260.class)
public abstract class AbstractRecipeBookScreenMixin extends AbstractContainerScreenMixin<class_1729> {
    @Shadow
    @Final
    private class_507<?> recipeBookComponent;

    protected AbstractRecipeBookScreenMixin(class_2561 title) {
        super(title);
    }

    @Override
    public class_11875 cursors_extended$cursorType(double mouseX, double mouseY) {
        if (this.recipeBookComponent.method_2605()) {
            RecipeBookWidgetAccessor recipeBook = (RecipeBookWidgetAccessor) this.recipeBookComponent;
            RecipeBookResultsAccessor recipesArea = (RecipeBookResultsAccessor) recipeBook.getRecipesArea();
            RecipeAlternativesWidgetAccessor alternatesWidget = (RecipeAlternativesWidgetAccessor) recipesArea.getAlternatesWidget();

            if (((class_508) alternatesWidget).method_2616()) {
                return cursors_extended$getAlternatesWidgetCursor(alternatesWidget);
            }

            if (recipesArea.getHoveredResultButton() != null) {
                return CursorTypeUtil.canShift() ? CursorTypesExt.SHIFT : class_11876.field_62455;
            }
        }

        return super.cursors_extended$cursorType(mouseX, mouseY);
    }

    @Unique
    private class_11875 cursors_extended$getAlternatesWidgetCursor(RecipeAlternativesWidgetAccessor alternatesWidget) {
        for (class_339 alternativeButton : alternatesWidget.getAlternativeButtons()) {
            if (alternativeButton.method_37303() && alternativeButton.method_49606()) {
                return CursorTypeUtil.canShift() ? CursorTypesExt.SHIFT : class_11876.field_62455;
            }
        }
        return class_11876.field_62452;
    }
}
