package io.github.fishstiz.cursors_extended.mixin.cursorprovider.menus;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.class_11875;
import net.minecraft.class_2561;
import net.minecraft.class_8881;
import net.minecraft.class_8898;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import static io.github.fishstiz.cursors_extended.CursorsExtended.CONFIG;

@Mixin(class_8898.class)
public abstract class CrafterScreenMixin extends AbstractContainerScreenMixin<class_8881> {
    protected CrafterScreenMixin(class_2561 title) {
        super(title);
    }

    @ModifyArg(method = "renderSlot", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/GuiGraphics;requestCursor(Lcom/mojang/blaze3d/platform/cursor/CursorType;)V"
    ))
    private class_11875 onRequestCursor(
            class_11875 cursorType,
            @Local(argsOnly = true, ordinal = 0) int mouseX,
            @Local(argsOnly = true, ordinal = 1) int mouseY
    ) {
        if (CONFIG.isLegacyMode()) {
            class_11875 provided = cursors_extended$cursorType(mouseX, mouseY);
            if (CursorTypeUtil.nonDefault(provided)) {
                return provided;
            }
        }
        return cursorType;
    }
}
