package io.github.fishstiz.cursors_extended.mixin.cursorprovider.menus;

import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.class_11875;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_481;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(class_481.class)
public abstract class CreativeModeInventoryScreenMixin extends AbstractContainerScreenMixin<class_481.class_483> {
    @Shadow
    private class_1735 destroyItemSlot;

    protected CreativeModeInventoryScreenMixin(class_2561 title) {
        super(title);
    }

    @Override
    public class_11875 cursors_extended$cursorType(double mouseX, double mouseY) {
        if (CursorTypeUtil.canShift()
            && this.hoveredSlot != null
            && this.hoveredSlot == this.destroyItemSlot) {
            return CursorTypesExt.SHIFT;
        }
        return super.cursors_extended$cursorType(mouseX, mouseY);
    }

    @ModifyArg(
            method = "renderBg",
            slice = @Slice(from = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen;insideScrollbar(DD)Z"
            )),
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/GuiGraphics;requestCursor(Lcom/mojang/blaze3d/platform/cursor/CursorType;)V",
                    ordinal = 0
            )
    )
    private class_11875 onRequestCursor(class_11875 cursorType) {
        return CursorTypeUtil.applyScrollbarConfig(cursorType);
    }
}
