package io.github.fishstiz.cursors_extended.mixin.cursorprovider.menus;

import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.class_11875;
import net.minecraft.class_3979;
import net.minecraft.class_494;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value = {class_494.class, class_3979.class})
public abstract class ScrollingMenuScreenMixin {
    @ModifyArg(
            method = "renderBg",
            slice = @Slice(from = @At(
                    value = "FIELD",
                    target = "Lcom/mojang/blaze3d/platform/cursor/CursorTypes;RESIZE_NS:Lcom/mojang/blaze3d/platform/cursor/CursorType;",
                    opcode = Opcodes.GETSTATIC
            )),
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/GuiGraphics;requestCursor(Lcom/mojang/blaze3d/platform/cursor/CursorType;)V",
                    ordinal = 0
            )
    )
    private class_11875 onRequestCursor(class_11875 cursorType) {
        return CursorTypeUtil.applyScrollbarConfig(cursorType);
    }
}
