package io.github.fishstiz.cursors_extended.gui.screen;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.gui.widget.AbstractListWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ButtonWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ElementSlidingBackground;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import net.minecraft.class_11876;
import net.minecraft.class_11905;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8083;
import net.minecraft.client.gui.components.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public abstract class CatalogBrowserScreen extends class_437 {
    private static final class_2561 SEARCH_TEXT = class_2561.method_43471("cursors_extended.options.search");
    private static final class_7919 CLEAR_SEARCH_INFO = class_7919.method_47407(class_2561.method_43471("cursors_extended.options.search.clear"));
    private static final class_7919 REFRESH_INFO = class_7919.method_47407(class_2561.method_43471("cursors_extended.options.refresh.info"));
    private static final class_2960 EXIT_SPRITE = CursorsExtended.loc("textures/gui/sprites/icon/caret_right.png");
    private static final class_2960 CLEAR_SPRITE = CursorsExtended.loc("textures/gui/sprites/icon/cross.png");
    private static final class_2960 REFRESH_SPRITE = CursorsExtended.loc("textures/gui/sprites/icon/arrow_clockwise.png");
    private final class_437 previous;
    private final int headerHeight;
    private final int sidebarWidth;
    private final int maxContentWidth;
    private final int spacing;
    private final Map<CatalogItem, ItemContext> items = new LinkedHashMap<>();
    private class_342 searchField;
    private ButtonWidget clearButton;
    private ItemList catalog;
    private ButtonWidget doneButton;
    private ButtonWidget refreshButton;
    private ContentPanel contents;
    private String previousSearch = "";

    protected CatalogBrowserScreen(class_2561 title, int headerHeight, int sidebarWidth, int maxContentWidth, int spacing, class_437 previous) {
        super(title);

        this.headerHeight = headerHeight;
        this.sidebarWidth = sidebarWidth;
        this.maxContentWidth = maxContentWidth;
        this.spacing = spacing;
        this.previous = previous;
    }

    protected void initItems() {
    }

    protected void postInit() {
    }

    @Override
    protected final void method_25426() {
        this.doneButton = this.method_37063(new ButtonWidget(class_5244.field_24334, this::method_25419)
                .withSize(class_4185.field_39501)
                .withTooltip(class_5244.field_24334)
                .spriteOnly(EXIT_SPRITE)
        );

        this.clearButton = new ButtonWidget(class_5244.field_39003, this::clearSearch)
                .withSize(class_4185.field_39501)
                .withTooltip(CLEAR_SEARCH_INFO)
                .spriteOnly(CLEAR_SPRITE);
        this.clearButton.field_22763 = false;

        this.searchField = this.method_37063(new class_342(
                this.field_22793,
                this.sidebarWidth - this.clearButton.method_25368() - this.spacing,
                this.headerHeight,
                SEARCH_TEXT
        ));
        this.searchField.method_47404(SEARCH_TEXT);
        this.searchField.method_1863(this::search);

        this.method_37063(this.clearButton);

        this.catalog = this.method_37063(new ItemList(
                this.field_22787,
                this.field_22793,
                this.sidebarWidth,
                this.spacing,
                this::onItemChange
        ));

        this.refreshButton = this.method_37063(new ButtonWidget(class_5244.field_39003, this::refreshItemsAndPanel)
                .withSize(class_4185.field_39501)
                .withTooltip(REFRESH_INFO)
                .spriteOnly(REFRESH_SPRITE)
        );

        this.initItems();
        this.refreshItems();
        this.method_48640();
        this.postInit();
    }

    @Override
    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.previous);
        }
    }

    @Override
    public void method_25432() {
        if (this.contents != null) {
            this.contents.removed();
        }
    }

    @Override
    protected final void method_48640() {
        int contentsWidth = this.getContentWidth();
        int usableWidth = this.sidebarWidth + this.spacing + contentsWidth;

        int maxOffsetX = this.field_22789 - usableWidth - this.spacing;
        int leftColumnX = Math.max(this.spacing, Math.min((this.field_22789 - usableWidth) / 2, maxOffsetX));
        int rightColumnX = leftColumnX + this.sidebarWidth + this.spacing;

        if (this.doneButton != null && this.refreshButton != null) {
            this.doneButton.method_48229(rightColumnX + contentsWidth - this.doneButton.method_25368(), this.spacing);
            this.refreshButton.method_48229(this.doneButton.method_46426() - this.refreshButton.method_25368() - this.spacing, this.spacing);
        }
        if (this.searchField != null && this.clearButton != null) {
            this.searchField.method_48229(leftColumnX, this.spacing);
            this.clearButton.method_48229(this.searchField.method_55442() + this.spacing, this.spacing);
        }
        if (this.catalog != null) {
            this.catalog.method_53533(this.field_22790 - this.spacing * 2 - (this.headerHeight + this.spacing));
            this.catalog.method_48229(leftColumnX, this.spacing + this.headerHeight + this.spacing);
            this.catalog.clampScrollAmount();
        }
        if (this.contents != null) {
            this.contents.setWidth(contentsWidth);
            this.contents.setHeight(this.field_22790 - this.spacing * 2);
            this.contents.method_48229(rightColumnX, this.spacing);
            this.contents.repositionElements();
        }
    }

    protected int getContentWidth() {
        int totalWidth = this.field_22789 - this.spacing * 2;

        return this.maxContentWidth <= 0
                ? totalWidth - this.sidebarWidth - this.spacing
                : Math.min(this.maxContentWidth, totalWidth - this.sidebarWidth - this.spacing);
    }

    protected void selectItem(@Nullable CatalogItem item) {
        if (item != null) {
            this.catalog.select(item);
        } else {
            this.catalog.select((CatalogItem) null);
            if (this.contents != null) {
                this.method_37066(this.contents);
                this.contents.removed();
                this.contents = null;
            }
        }
    }

    private void onItemChange(CatalogItem item) {
        ItemContext itemContext = this.items.get(item);

        if (itemContext == null) {
            throw new NullPointerException("CatalogItem " + item.id() + " context not found.");
        }

        ContentPanel contentPanel = itemContext.contents();
        if (contentPanel != this.contents) {
            if (this.contents != null) {
                this.method_37066(this.contents);
                this.contents.removed();
            }

            this.contents = contentPanel;
            this.contents.changedItem(this.previousSearch, itemContext.category(), item);
            this.method_37063(this.contents);
            this.contents.added(this.previousSearch);
        } else {
            this.contents.changedItem(this.previousSearch, itemContext.category(), item);
        }

        this.method_48640();
    }

    protected CatalogItem addCategory(@NotNull CatalogItem category, boolean collapsible, boolean collapsed) {
        this.catalog.addCategory(Objects.requireNonNull(category), new CategoryContext(collapsible, collapsed));
        return category;
    }

    protected CatalogItem addCategory(@NotNull CatalogItem category) {
        return this.addCategory(category, true, false);
    }

    protected void addCategoryOnly(@NotNull CatalogItem category, @NotNull ContentPanel panel) {
        this.addCategory(category, false, true);
        this.items.put(category, new ItemContext(category, this.initPanel(panel)));
    }

    protected void addItem(@NotNull CatalogItem category, @NotNull CatalogItem item, @NotNull ContentPanel panel) {
        if (this.items.containsKey(Objects.requireNonNull(category))) {
            throw new IllegalStateException("Category " + category.id() + " is already an item.");
        }

        this.items.put(Objects.requireNonNull(item), new ItemContext(category, this.initPanel(panel)));
        this.catalog.addItem(category, item);
    }

    protected void updateItem(@NotNull CatalogItem item, @NotNull ContentPanel contentPanel) {
        ItemContext oldContext = this.items.get(item);
        if (oldContext == null) {
            throw new IllegalStateException("CatalogItem " + item.id() + " has not beed added.");
        }

        ItemContext context = Objects.requireNonNull(this.items.computeIfPresent(item, (i, ctx) ->
                new ItemContext(ctx.category(), this.initPanel(contentPanel))
        ));

        this.items.replace(item, context);
        this.catalog.replaceItem(context.category(), item);

        if (this.contents != null && this.contents == oldContext.contents() && item.equals(this.contents.getItem())) {
            if (oldContext.contents() != context.contents()) {
                boolean isFocused = this.method_25399() == this.contents;

                this.method_37066(this.contents);
                this.contents.removed();

                this.contents = context.contents();
                if (isFocused) this.method_25395(this.contents);

                this.contents.changedItem(this.previousSearch, context.category(), item);

                this.method_37063(this.contents);
                this.contents.added(this.previousSearch);
            } else {
                this.contents.changedItem(this.previousSearch, context.category(), item);
            }
            this.method_48640();
        }
    }

    protected void addOrUpdateItem(@NotNull CatalogItem category, @NotNull CatalogItem item, @NotNull ContentPanel panel) {
        if (this.items.containsKey(item)) {
            this.updateItem(item, panel);
        } else {
            this.addItem(category, item, panel);
        }
    }

    protected void refreshItems() {
        this.catalog.refreshEntries();
    }

    protected void refreshItemsAndPanel() {
        this.refreshItems();
        if (this.contents != null) {
            this.contents.removed();
            this.contents.added();
        }
        this.method_48640();
    }

    protected class_4185 getRefreshButton() {
        return this.refreshButton;
    }

    private ContentPanel initPanel(ContentPanel panel) {
        panel.init(
                this.field_22787,
                this.field_22793,
                this,
                this.headerHeight,
                this.getContentWidth() - this.doneButton.method_25368() - this.refreshButton.method_25368() - this.spacing * 2,
                this.spacing
        );
        return panel;
    }

    protected void focusPath(class_364 child) {
        this.method_48267();
        class_8016.method_48194(child, this).method_48195(true);
    }

    protected boolean autoFocusSearch() {
        return true;
    }

    @Override
    public boolean method_25400(class_11905 charEvent) {
        if (super.method_25400(charEvent)) {
            return true;
        }
        if (this.autoFocusSearch()
            && charEvent.comp_4793() != class_3675.field_31947
            && this.searchField != null
            && !this.searchField.method_25370()) {
            this.focusPath(this.searchField);
            return this.searchField.method_25400(charEvent);
        }
        return false;
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        if (super.method_25404(keyEvent)) {
            return true;
        }
        if (this.autoFocusSearch()
            && keyEvent.comp_4795() == class_3675.field_31986
            && this.searchField != null
            && !this.searchField.method_25370()
            && !this.searchField.method_1882().isEmpty()) {
            this.focusPath(this.searchField);
            return this.searchField.method_25404(keyEvent);
        }
        return false;
    }

    private void clearSearch() {
        if (this.searchField != null) {
            this.searchField.method_1852("");
        }
    }

    private void search(String search) {
        if (this.clearButton != null) {
            this.clearButton.field_22763 = !search.isEmpty();
        }
        if (Objects.equals(this.previousSearch, search)) {
            return;
        }

        this.previousSearch = search;
        if (search.isEmpty()) {
            this.catalog.filterItems(null);
            this.refreshItems();
            if (this.contents != null) {
                this.contents.searched(search, null);
            }
        } else {
            SearchResult result = this.performSearch(search.toLowerCase());
            this.catalog.filterItems(result.visibleItems());
            if (result.firstResult() != null) {
                this.selectItem(result.firstResult());
            }
            this.refreshItems();
            if (this.contents != null) {
                this.contents.searched(search, result.firstMatch());
            }
        }
    }

    private SearchResult performSearch(String lowercaseSearch) {
        Map<CatalogItem, Set<CatalogItem>> visibleItems = new HashMap<>();
        CatalogItem firstResult = null;
        class_2561 firstMatch = null;

        for (Map.Entry<CatalogItem, ItemContext> itemEntry : this.items.entrySet()) {
            CatalogItem item = itemEntry.getKey();
            ItemContext context = itemEntry.getValue();

            MatchResult matchResult = this.findMatch(item, context, lowercaseSearch);
            if (matchResult.hasMatch()) {
                if (firstResult == null) {
                    firstResult = item;
                    firstMatch = matchResult.matchedText();
                }
                visibleItems.computeIfAbsent(context.category(), k -> new HashSet<>()).add(item);
            }
        }

        return new SearchResult(visibleItems, firstResult, firstMatch);
    }

    private MatchResult findMatch(CatalogItem item, ItemContext context, String lowercaseSearch) {
        class_2561 matchedText = containsStringLowerCase(context.contents().indexed, lowercaseSearch);
        if (matchedText != null) {
            return new MatchResult(true, matchedText);
        }

        if (containsStringLowerCase(item.text(), lowercaseSearch)) {
            return new MatchResult(true, null);
        }

        if (containsStringLowerCase(context.category().text(), lowercaseSearch)) {
            return new MatchResult(true, null);
        }

        return new MatchResult(false, null);
    }

    private static boolean containsStringLowerCase(class_2561 text, String string) {
        return text.method_27662().getString().toLowerCase().contains(string);
    }

    private static @Nullable class_2561 containsStringLowerCase(List<class_2561> texts, String string) {
        for (class_2561 text : texts) {
            if (containsStringLowerCase(text, string)) {
                return text;
            }
        }
        return null;
    }

    private static class ItemList extends AbstractListWidget<ItemList.AbstractItemEntry> {
        private static final int UNPADDED_HEIGHT = 8;
        private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF); // 15% white
        private final ElementSlidingBackground selectedBackground = new ElementSlidingBackground(0x33FFFFFF); // 20% white
        private final ElementSlidingBackground focusedBackground = new ElementSlidingBackground(0xFFFFFFFF, true); // white
        private final Map<CatalogItem, CategoryContext> categories = new LinkedHashMap<>();
        private final Map<CatalogItem, Set<CatalogItem>> visibleItems = new HashMap<>();
        private final Consumer<CatalogItem> onSelect;
        private final class_327 font;
        private final int spacing;
        private boolean searching;
        private @Nullable CatalogItem selectedItem;

        private ItemList(class_310 minecraft, class_327 font, int width, int spacing, Consumer<CatalogItem> onSelect) {
            super(minecraft, width, 0, 0, UNPADDED_HEIGHT + spacing * 2);

            this.onSelect = onSelect;
            this.font = font;
            this.spacing = spacing;
        }

        private void addCategory(CatalogItem category, CategoryContext context) {
            this.categories.put(category, context);
        }

        private void addItem(CatalogItem category, CatalogItem item) {
            CategoryContext context = this.categories.computeIfAbsent(category, c -> new CategoryContext());
            context.items().add(item);
        }

        private void replaceItem(@NotNull CatalogItem category, @NotNull CatalogItem item) {
            int index = this.indexOf(category, item);
            if (index == -1) {
                throw new IllegalStateException("CatalogItem " + item.id() + " has not beed added.");
            }
            this.categories.get(category).items().set(index, item);
        }

        private int indexOf(@NotNull CatalogItem category, @Nullable CatalogItem item) {
            CategoryContext context = this.categories.get(category);
            if (context != null) {
                List<CatalogItem> items = context.items();
                for (int i = 0; i < items.size(); i++) {
                    if (Objects.equals(items.get(i), item)) {
                        return i;
                    }
                }
            }
            return -1;
        }

        private void filterItems(@Nullable Map<CatalogItem, Set<CatalogItem>> visibleItems) {
            this.visibleItems.clear();
            this.searching = visibleItems != null;

            if (this.searching) {
                this.visibleItems.putAll(visibleItems);
            }
        }

        private void refreshEntries() {
            AbstractItemEntry focusedEntry = this.method_25336();
            AbstractItemEntry selectedEntry = this.method_25334();

            this.method_25339();
            this.method_25395(null);

            for (Map.Entry<CatalogItem, CategoryContext> categoryContexts : this.categories.entrySet()) {
                if (this.searching && !this.visibleItems.containsKey(categoryContexts.getKey())) {
                    continue;
                }

                CategoryContext categoryContext = categoryContexts.getValue();

                CatalogItem categoryItem = categoryContexts.getKey()
                        .withText(text -> text.method_27661().method_27694(style -> style.method_10982(true)))
                        .withPrefix(CategoryEntry.applyCollapsibleSymbol(categoryContext));

                CategoryEntry categoryEntry = new CategoryEntry(this.font, categoryItem, categoryContext.collapsible(), this.spacing);
                this.method_25321(categoryEntry);

                if (!categoryContext.collapsed()) {
                    Set<CatalogItem> items = this.visibleItems.get(categoryItem);
                    for (CatalogItem item : categoryContexts.getValue().items()) {
                        if (!this.searching || (items != null && (items.isEmpty() || items.contains(item)))) {
                            ItemEntry selectableEntry = new ItemEntry(this.font, item, this.spacing);
                            this.method_25321(selectableEntry);
                        }
                    }
                }
            }

            this.method_25395(focusedEntry);
            if (focusedEntry != selectedEntry) this.setSelected(selectedEntry);

            this.clampScrollAmount();
        }

        private void select(CatalogItem item, @Nullable AbstractItemEntry itemEntry) {
            if (this.selectedItem == null || !this.selectedItem.equals(item)) {
                this.selectedItem = item;
                this.method_25395(itemEntry);
                if (itemEntry != null) {
                    this.method_73377(itemEntry);
                }

                this.onSelect.accept(this.selectedItem);
            }
        }

        private void select(AbstractItemEntry itemEntry) {
            this.select(itemEntry.getItem(), itemEntry);
        }

        private void select(@Nullable CatalogItem item) {
            if (item != null) {
                this.select(item, this.getEntryFromItem(item));
            } else {
                this.selectedItem = null;
            }
        }

        private void toggleCategory(AbstractItemEntry itemEntry) {
            if (!(itemEntry instanceof CategoryEntry categoryEntry)) {
                throw new IllegalArgumentException("Entry is not an instance of CategoryEntry");
            }

            CatalogItem category = categoryEntry.getItem();
            CategoryContext context = this.categories.computeIfPresent(category, (c, ctx) -> ctx.toggle());

            this.method_25395(categoryEntry);

            this.refreshEntries();

            AbstractItemEntry focused = this.method_25336();
            if (focused != null) {
                focused.setFocused(focused.button);
            }

            if (context != null && !context.collapsed() && this.indexOf(category, this.selectedItem) == -1) {
                this.select(context.items().getFirst());
            }
        }

        private @Nullable AbstractItemEntry getEntryFromItem(@Nullable CatalogItem item) {
            if (item != null) {
                for (AbstractItemEntry entry : this.method_25396()) {
                    if (entry.getItem().equals(item)) {
                        return entry;
                    }
                }
            }
            return null;
        }

        private void renderSlidingBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.hoveredBackground.render(guiGraphics, this.method_25308(mouseX, mouseY), partialTick);
            this.selectedBackground.render(guiGraphics, this.getEntryFromItem(this.selectedItem), partialTick);
            this.focusedBackground.render(guiGraphics, this.method_25336(), partialTick);
        }

        @Override
        public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
            this.focusedBackground.reset();
            this.selectedBackground.reset();
            return super.method_25401(mouseX, mouseY, scrollX, scrollY);
        }

        @Override
        public void method_25311(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderSlidingBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.method_25311(guiGraphics, mouseX, mouseY, partialTick);
        }

        @Override
        public void method_25395(@Nullable class_364 focused) {
            if (focused instanceof AbstractItemEntry itemEntry) {
                focused = this.getEntryFromItem(itemEntry.getItem());
            }
            super.method_25395(focused);
        }

        @Override
        public void setSelected(@Nullable AbstractItemEntry selected) {
            if (selected != null) {
                selected = this.getEntryFromItem(selected.getItem());
            }
            super.method_25313(selected);
        }

        private abstract class AbstractItemEntry extends AbstractListWidget<AbstractItemEntry>.Entry {
            protected final class_327 font;
            protected final CatalogItem item;
            protected final ItemButton button;
            protected final List<ItemButton> children;

            protected AbstractItemEntry(class_327 font, CatalogItem item, int spacing, Consumer<AbstractItemEntry> onClick) {
                this.font = font;
                this.item = item;
                this.button = new ItemButton(this.item, this.font, spacing, itemButton -> onClick.accept(this));
                this.children = Collections.singletonList(this.button);
            }

            CatalogItem getItem() {
                return this.item;
            }

            @Override
            public void renderContent(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
                this.button.method_55445(this.getWidth(), this.getHeight());
                this.button.method_48229(this.getX(), this.getY());
                this.button.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }

            @Override
            public void setFocused(boolean focused) {
                super.setFocused(focused);

                class_364 focusedElement = this.getFocused();
                if (focusedElement != null) {
                    focusedElement.method_25365(focused);
                }
            }

            @Override
            public @NotNull List<ItemButton> children() {
                return this.children;
            }

            @Override
            public @NotNull List<ItemButton> narratables() {
                return this.children;
            }
        }

        private class CategoryEntry extends AbstractItemEntry {
            private static final class_2561 COLLAPSED_SYMBOL = wrapSymbol("▶");
            private static final class_2561 COLLAPSIBLE_SYMBOL = wrapSymbol("▼");
            private static final class_2561 NON_COLLAPSIBLE_SYMBOL = wrapSymbol("■");
            private static final int SYMBOL_COLOR = 0xFFFFFFFF; // white

            private CategoryEntry(class_327 font, CatalogItem item, boolean collapsible, int spacing) {
                super(font, item, spacing, collapsible ? ItemList.this::toggleCategory : ItemList.this::select);
            }

            private static class_2561 wrapSymbol(String symbol) {
                return class_2561.method_43470(symbol).method_27694(style -> style.method_10982(true));
            }

            private static UnaryOperator<CatalogItem.Prefix> applyCollapsibleSymbol(CategoryContext context) {
                class_2561 symbol;
                if (!context.collapsible()) {
                    symbol = NON_COLLAPSIBLE_SYMBOL;
                } else if (context.collapsed()) {
                    symbol = COLLAPSED_SYMBOL;
                } else {
                    symbol = COLLAPSIBLE_SYMBOL;
                }

                return prefix -> {
                    if (prefix != null) return prefix;

                    return (guiGraphics, font, item, bounds, spacing, mouseX, mouseY, partialTick) -> {
                        int x = bounds.method_46426() + spacing;
                        int y = bounds.method_46427() + (bounds.method_25364() - font.field_2000) / 2;
                        int width = Math.max(font.method_27525(NON_COLLAPSIBLE_SYMBOL), Math.max(font.method_27525(COLLAPSED_SYMBOL), font.method_27525(COLLAPSIBLE_SYMBOL)));
                        int endX = x + width;
                        int endY = y + font.field_2000;

                        DrawUtil.drawScrollableTextLeftAlign(guiGraphics, font, symbol, x, y, endX, endY, SYMBOL_COLOR);

                        return width;
                    };
                };
            }
        }

        private class ItemEntry extends AbstractItemEntry {
            private ItemEntry(class_327 font, CatalogItem item, int spacing) {
                super(font, item, spacing, ItemList.this::select);
            }
        }
    }

    private static class ItemButton extends class_4264 {
        private static final int TEXT_COLOR = 0xFFFFFFFF; // white
        private final Consumer<ItemButton> onClick;
        private final CatalogItem item;
        private final class_327 font;
        private final int spacing;

        public ItemButton(CatalogItem item, class_327 font, int spacing, Consumer<ItemButton> onClick) {
            super(0, 0, 0, 0, item.text());

            this.font = font;
            this.item = item;
            this.spacing = spacing;
            this.onClick = Objects.requireNonNull(onClick);
        }

      @Override
        public void method_25306(class_11907 inputWithModifiers) {
            this.onClick.accept(this);
        }

        @Override
        protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            int prefixWidth = this.item.prefix() != null
                    ? this.item.prefix().render(guiGraphics, this.font, this.item, this, this.spacing, mouseX, mouseY, partialTick)
                    : 0;

            if (prefixWidth > 0) {
                prefixWidth += this.spacing;
            }

            int startX = this.method_46426() + this.spacing + prefixWidth;
            int startY = this.method_46427() + (this.method_25364() - this.font.field_2000) / 2;
            int endX = this.method_55442() - this.spacing;
            int endY = startY + this.font.field_2000;

            DrawUtil.drawScrollableTextLeftAlign(guiGraphics, this.font, this.method_25369(), startX, startY, endX, endY, TEXT_COLOR);

            if (this.method_49606()) {
                guiGraphics.method_74037(class_11876.field_62455);
            }
        }

        @Override
        protected void method_47399(@NotNull class_6382 narrationElementOutput) {
            narrationElementOutput.method_37034(class_6381.field_33788, this.method_25369());
        }
    }

    public abstract static class ContentPanel extends class_362 implements class_4068, class_6379, class_8021 {
        private final List<class_2561> indexed = new ArrayList<>();
        private final List<class_364> children = new ArrayList<>();
        private final List<class_4068> renderables = new ArrayList<>();
        private final List<class_6379> narratables = new ArrayList<>();
        private int x;
        private int y;
        private int width;
        private int height;
        private class_6379 lastNarratable;
        private CatalogItem item;
        private CatalogItem category;
        private boolean initialized;
        private int spacing;
        private int headerHeight;
        private int headerWidth;
        private class_310 minecraft;
        private class_327 font;
        private CatalogBrowserScreen catalog;
        private @NotNull String search = "";

        protected void added() {
        }

        protected void removed() {
        }

        protected void changed(@NotNull CatalogItem category, @NotNull CatalogItem item) {
        }

        protected void searched(@NotNull String search, @Nullable class_2561 matched) {
        }

        protected void repositionElements() {
        }

        protected abstract void init();

        private void init(class_310 minecraft, class_327 font, CatalogBrowserScreen catalog, int headerHeight, int headerWidth, int spacing) {
            if (!this.initialized) {
                this.initialized = true;
                this.minecraft = minecraft;
                this.font = font;
                this.catalog = catalog;
                this.spacing = spacing;
                this.headerHeight = headerHeight;
                this.headerWidth = headerWidth;
                this.init();
            }
        }

        private void added(@NotNull String search) {
            this.search = search;
            this.added();
        }

        private void changedItem(@NotNull String search, @NotNull CatalogItem category, @NotNull CatalogItem item) {
            this.category = Objects.requireNonNull(category);
            this.item = Objects.requireNonNull(item);
            this.search = search;
            this.changed(this.category, this.item);
        }

        protected void clearWidgets() {
            this.indexed.clear();
            this.children.clear();
            this.renderables.clear();
            this.narratables.clear();
        }

        protected class_2561 index(class_2561 text) {
            this.indexed.add(text);
            return text;
        }

        protected <T extends class_4068 & class_364 & class_6379> void addRenderableWidget(T widget) {
            this.children.add(widget);
            this.narratables.add(widget);
            this.renderables.add(widget);
        }

        protected void addRenderableIndexedWidget(class_339 widget) {
            this.addRenderableWidget(widget);
            this.indexed.add(widget.method_25369());
        }

        protected final void changeItem(CatalogItem item) {
            this.catalog.selectItem(item);
        }

        protected CatalogBrowserScreen getScreen() {
            return this.catalog;
        }

        protected class_310 getMinecraft() {
            return this.minecraft;
        }

        protected class_327 getFont() {
            return this.font;
        }

        public CatalogItem getItem() {
            return this.item;
        }

        public CatalogItem getCategory() {
            return this.category;
        }

        public @NotNull String getSearch() {
            return this.search;
        }

        @Override
        public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            for (class_4068 renderable : this.renderables) {
                renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return mouseX >= this.method_46426() && mouseX < this.method_46426() + this.method_25368()
                   && mouseY >= this.method_46427() && mouseY < this.method_46427() + this.method_25364();
        }

        @Override
        public @NotNull List<class_364> method_25396() {
            return this.children;
        }

        @Override
        public void method_46421(int x) {
            this.x = x;
        }

        @Override
        public void method_46419(int y) {
            this.y = y;
        }

        @Override
        public int method_46426() {
            return this.x;
        }

        @Override
        public int method_46427() {
            return this.y;
        }

        private void setWidth(int width) {
            this.width = width;
        }

        @Override
        public int method_25368() {
            return this.width;
        }

        private void setHeight(int height) {
            this.height = height;
        }

        @Override
        public int method_25364() {
            return this.height;
        }

        public int getRight() {
            return this.method_46426() + this.method_25368();
        }

        public int getBottom() {
            return this.method_46427() + this.method_25364();
        }

        public int getSpacing() {
            return this.spacing;
        }

        public int getHeaderHeight() {
            return this.headerHeight;
        }

        public int getHeaderWidth() {
            return this.headerWidth;
        }

        @Override
        public @NotNull class_8030 method_48202() {
            return class_8021.super.method_48202();
        }

        @Override
        public void method_48206(Consumer<class_339> consumer) {
            for (var child : this.children) {
                if (child instanceof class_339 widget) {
                    consumer.accept(widget);
                }
            }
        }

        @Override
        public final @NotNull class_6380 method_37018() {
            return this.method_25370() ? class_6380.field_33786 : class_6380.field_33784;
        }

        @Override
        public final void method_37020(@NotNull class_6382 narrationElementOutput) {
            List<class_6379> sortedNarratables = this.narratables
                    .stream()
                    .filter(class_6379::method_37303)
                    .sorted(Comparator.comparingInt(class_8083::method_48590))
                    .toList();
            class_6390 narratableSearchResult = method_37061(sortedNarratables, this.lastNarratable);
            if (narratableSearchResult != null) {
                if (narratableSearchResult.comp_4465().method_37028()) {
                    this.lastNarratable = narratableSearchResult.comp_4463();
                }
                if (sortedNarratables.size() > 1 && narratableSearchResult.comp_4465() == class_6380.field_33786) {
                    narrationElementOutput.method_37034(class_6381.field_33791, class_2561.method_43471("narration.component_list.usage"));
                }
                narratableSearchResult.comp_4463().method_37020(narrationElementOutput.method_37031());
            }
        }
    }

    private record CategoryContext(boolean collapsible, boolean collapsed, @NotNull List<CatalogItem> items) {
        private CategoryContext {
            Objects.requireNonNull(items);
        }

        public CategoryContext(boolean collapsible, boolean collapsed) {
            this(collapsible, collapsed, new ArrayList<>());
        }

        public CategoryContext() {
            this(true, false, new ArrayList<>());
        }

        private CategoryContext toggle() {
            if (!this.collapsible) {
                throw new IllegalStateException("Cannot collapse non-collapsible category");
            }
            return new CategoryContext(true, !this.collapsed, this.items);
        }
    }

    private record ItemContext(@NotNull CatalogItem category, @NotNull ContentPanel contents) {
        private ItemContext {
            Objects.requireNonNull(category);
            Objects.requireNonNull(contents);
        }
    }

    private record SearchResult(
            Map<CatalogItem, Set<CatalogItem>> visibleItems,
            @Nullable CatalogItem firstResult,
            @Nullable class_2561 firstMatch
    ) {
    }

    private record MatchResult(boolean hasMatch, class_2561 matchedText) {
    }
}
