package io.github.fishstiz.cursors_extended.mixin.cursorprovider.menus;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_481;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_481.class)
public abstract class CreativeModeInventoryScreenMixin extends AbstractContainerScreenMixin<class_481.class_483> {
    @Shadow
    private boolean scrolling;

    @Shadow
    @Nullable
    private class_1735 destroyItemSlot;

    @Shadow
    private static class_1761 selectedTab;

    @Shadow
    protected abstract boolean insideScrollbar(double mouseX, double mouseY);

    protected CreativeModeInventoryScreenMixin(class_2561 title) {
        super(title);
    }

    @Override
    public class_11875 cursors_extended$cursorType(double mouseX, double mouseY) {
        if (CursorTypeUtil.canShift()
            && this.hoveredSlot != null
            && this.hoveredSlot == this.destroyItemSlot) {
            return CursorTypesExt.SHIFT;
        }
        return super.cursors_extended$cursorType(mouseX, mouseY);
    }

    @Inject(method = "renderBg", at = @At("RETURN"))
    private void forceDefaultOnScroll(class_332 guiGraphics, float partialTick, int mouseX, int mouseY, CallbackInfo ci) {
        if (selectedTab.method_7756()) {
            if (this.scrolling && CursorTypeUtil.isLeftClickHeld() && CursorsExtended.CONFIG.isResizeScrollbarEnabled()) {
                guiGraphics.method_74037(class_11876.field_62456);
            } else if (this.insideScrollbar(mouseX, mouseY) && CursorsExtended.CONFIG.isPointerScrollbarEnabled()) {
                guiGraphics.method_74037(class_11876.field_62455);
            }
        }
    }

    @Inject(method = "checkTabHovering", at = @At("RETURN"))
    private void setPointerOnHover(class_332 guiGraphics, class_1761 creativeModeTab, int mouseX, int mouseY, CallbackInfoReturnable<Boolean> cir) {
        if (CursorsExtended.CONFIG.isCreativeTabsEnabled()
            && creativeModeTab != selectedTab
            && cir.getReturnValue()
            && this.cursors_extended$cursorType(mouseX, mouseY) == class_11875.field_62449) {
            guiGraphics.method_74037(class_11876.field_62455);
        }
    }
}
