/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.compat.glfw;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class GLFWInternal {
    private static final AtomicInteger IS_CREATE_STANDARD_CURSOR = new AtomicInteger(0);
    private static final AtomicInteger IS_CREATE_CURSOR = new AtomicInteger(0);
    private static final AtomicInteger IS_SET_CURSOR = new AtomicInteger(0);
    private static final Set<Long> INTERNAL_CURSORS = new LongOpenHashSet();

    private GLFWInternal() {
    }

    public static boolean isCreatingStandardCursor() {
        return IS_CREATE_STANDARD_CURSOR.get() > 0;
    }

    public static boolean isCreatingCursor() {
        return IS_CREATE_CURSOR.get() > 0;
    }

    public static boolean isSettingCursor() {
        return IS_SET_CURSOR.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trackInternalCursor(long cursor) {
        Set<Long> set = INTERNAL_CURSORS;
        synchronized (set) {
            INTERNAL_CURSORS.add(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void untrackInternalCursor(long cursor) {
        Set<Long> set = INTERNAL_CURSORS;
        synchronized (set) {
            INTERNAL_CURSORS.remove(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInternalCursor(long cursor) {
        Set<Long> set = INTERNAL_CURSORS;
        synchronized (set) {
            return INTERNAL_CURSORS.contains(cursor);
        }
    }

    public static long createStandardCursor(int shape) {
        IS_CREATE_STANDARD_CURSOR.incrementAndGet();
        try {
            long l = GLFW.glfwCreateStandardCursor((int)shape);
            return l;
        }
        finally {
            IS_CREATE_STANDARD_CURSOR.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createCursor(GLFWImage glfwImage, int xhot, int yhot) {
        IS_CREATE_CURSOR.incrementAndGet();
        try {
            long l = GLFW.nglfwCreateCursor((long)glfwImage.address(), (int)xhot, (int)yhot);
            return l;
        }
        finally {
            IS_CREATE_CURSOR.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCursor(long window, long cursor) {
        IS_SET_CURSOR.incrementAndGet();
        try {
            GLFW.glfwSetCursor((long)window, (long)cursor);
        }
        finally {
            IS_SET_CURSOR.decrementAndGet();
        }
    }
}

