/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor.debug;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.debug.CursorDebugRenderer;
import io.github.fishstiz.cursors_extended.platform.Services;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

class CursorDebugRendererImpl
implements CursorDebugRenderer {
    private static final float TEXT_SCALE = 0.75f;
    private final class_2561 screenLabel = class_2561.method_43470((String)"S: ").method_54663(-13394945);
    private final class_2561 deepestLabel = class_2561.method_43470((String)"D: ").method_54663(-16711936);
    private final class_2561 inspectedLabel = class_2561.method_43470((String)"I: ").method_54663(-65536);
    private final class_2561 virtualModeLabel = class_2561.method_43470((String)"Virtual Mode: ").method_27692(class_124.field_1065);
    private class_8030 inspectedBounds;
    private String inspectedElement;

    CursorDebugRendererImpl() {
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setLastCursorAt(class_364 inspected, double mouseX, double mouseY) {
        if (CursorTypeUtil.isHovered(inspected, mouseX, mouseY)) {
            this.inspectedBounds = this.getBounds(inspected);
            this.inspectedElement = this.getClassName(inspected);
        }
    }

    @Override
    public void render(class_310 minecraft, Supplier<@Nullable class_437> visibleScreen, class_332 guiGraphics, double mouseX, double mouseY) {
        class_437 screen = visibleScreen.get();
        if (screen != null) {
            class_8030 screenRectangle = this.getBounds((class_364)screen);
            this.renderScreenName(minecraft, screen, screenRectangle, guiGraphics);
            this.renderInspected(minecraft, this.renderDeepest(minecraft, screen, guiGraphics, mouseX, mouseY), guiGraphics);
            this.renderVirtualInfo(minecraft, screenRectangle, guiGraphics);
        }
    }

    private class_8030 renderDeepest(class_310 minecraft, class_437 screen, class_332 guiGraphics, double mouseX, double mouseY) {
        class_364 child = CursorDebugRendererImpl.findDeepest((class_4069)screen, mouseX, mouseY);
        class_364 inspect = child != null ? child : screen;
        class_8030 bounds = this.getBounds(inspect);
        class_5250 label = this.deepestLabel.method_27661().method_27693(this.getClassName(inspect));
        this.renderInfo(minecraft, guiGraphics, bounds, (class_2561)label, Position.TOP_LEFT, true);
        return bounds;
    }

    private void renderInspected(class_310 minecraft, class_8030 container, class_332 guiGraphics) {
        if (this.inspectedBounds != null) {
            class_5250 label = this.inspectedLabel.method_27661().method_27693(this.inspectedElement);
            int index = this.inspectedBounds.method_49618() != container.method_49618() ? 0 : 1;
            this.renderInfo(minecraft, guiGraphics, this.inspectedBounds, (class_2561)label, Position.TOP_LEFT, index, true);
        }
    }

    private void renderScreenName(class_310 minecraft, class_437 screen, class_8030 bounds, class_332 guiGraphics) {
        class_5250 label = this.screenLabel.method_27661().method_27693(this.getClassName((class_364)screen));
        this.renderInfo(minecraft, guiGraphics, bounds, (class_2561)label, Position.BOTTOM_RIGHT, false);
    }

    private void renderVirtualInfo(class_310 minecraft, class_8030 screenBounds, class_332 guiGraphics) {
        class_5250 virtualMode = this.virtualModeLabel.method_27661().method_10852(CursorsExtended.getInstance().getDisplay().isVirtual() ? class_5244.field_24332 : class_5244.field_24333);
        this.renderInfo(minecraft, guiGraphics, screenBounds, (class_2561)virtualMode, Position.TOP_RIGHT, false);
    }

    private void renderInfo(class_310 minecraft, class_332 guiGraphics, class_8030 bounds, class_2561 label, Position pos, boolean outline) {
        this.renderInfo(minecraft, guiGraphics, bounds, label, pos, 0, outline);
    }

    private void renderInfo(class_310 minecraft, class_332 guiGraphics, class_8030 bounds, class_2561 label, Position pos, int index, boolean outline) {
        class_5251 textColor = label.method_10866().method_10973();
        int color = 0xFF000000 | (textColor != null ? textColor.method_27716() : -1);
        int textX = pos.getX(minecraft, bounds, label, 0.75f);
        int textY = pos.getY(minecraft, bounds, index, 0.75f);
        Matrix3x2fStack matrix3x2fStack = guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_71048();
        if (outline) {
            DrawUtil.renderOutline(guiGraphics, bounds.method_49620(), bounds.method_49618(), bounds.comp_1196(), bounds.comp_1197(), color);
        }
        matrix3x2fStack.translate(0.75f, 0.75f);
        matrix3x2fStack.scale(0.75f, 0.75f);
        guiGraphics.method_27535(minecraft.field_1772, label, textX, textY, color);
        matrix3x2fStack.popMatrix();
    }

    private class_8030 getBounds(@Nullable class_364 element) {
        if (element instanceof class_8021) {
            class_8021 layoutElement = (class_8021)element;
            return layoutElement.method_48202();
        }
        return element != null ? element.method_48202() : class_8030.method_48248();
    }

    private String getClassName(class_364 element) {
        String namespace = Services.PLATFORM.isDevelopmentEnvironment() ? "named" : "intermediary";
        return Services.PLATFORM.unmapClassName(namespace, element.getClass().getName());
    }

    @Nullable
    private static class_364 findDeepest(class_4069 parent, double mouseX, double mouseY) {
        if (CursorTypeUtil.isHovered((class_364)parent, mouseX, mouseY)) {
            for (class_364 child : parent.method_25396()) {
                class_4069 nestedParent;
                class_364 nestedChild;
                if (child instanceof class_4069 && (nestedChild = CursorDebugRendererImpl.findDeepest(nestedParent = (class_4069)child, mouseX, mouseY)) != null) {
                    return nestedChild;
                }
                if (!CursorTypeUtil.isHovered(child, mouseX, mouseY)) continue;
                return child;
            }
        }
        return null;
    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

        private static final int PADDING = 2;

        public int getX(class_310 minecraft, class_8030 bounds, class_2561 text, float scale) {
            int screenWidth = minecraft.method_22683().method_4486();
            int textWidth = minecraft.field_1772.method_27525((class_5348)text);
            int x = switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> (int)((float)(bounds.method_49620() + 2) / scale);
                case 1, 3 -> {
                    int unscaledX = bounds.method_49620() + bounds.comp_1196() - (int)((float)textWidth * scale) - 2;
                    yield (int)((float)unscaledX / scale);
                }
            };
            if ((float)(x + textWidth) * scale > (float)screenWidth && (x = (int)(((float)screenWidth - (float)textWidth * scale - 2.0f) / scale)) < 0) {
                x = 0;
            }
            return x;
        }

        public int getY(class_310 minecraft, class_8030 bounds, int index, float scale) {
            int screenHeight = minecraft.method_22683().method_4502();
            Objects.requireNonNull(minecraft.field_1772);
            int textHeight = 9;
            int offsetY = index * textHeight;
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> (int)((float)(bounds.method_49618() + 2 + offsetY) / scale);
                case 2, 3 -> bounds.comp_1197() == 0 && bounds.comp_1196() == 0 ? (int)((float)(screenHeight - textHeight - 2 - offsetY) / scale) : (int)((float)(bounds.method_49618() - 2 + Math.max(0, bounds.comp_1197() - textHeight) + offsetY) / scale);
            };
        }
    }
}

