/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.screen;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.gui.screen.CatalogItem;
import io.github.fishstiz.cursors_extended.gui.widget.AbstractListWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ButtonWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ElementSlidingBackground;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_11876;
import net.minecraft.class_11905;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8083;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CatalogBrowserScreen
extends class_437 {
    private static final class_2561 SEARCH_TEXT = class_2561.method_43471((String)"cursors_extended.options.search");
    private static final class_7919 CLEAR_SEARCH_INFO = class_7919.method_47407((class_2561)class_2561.method_43471((String)"cursors_extended.options.search.clear"));
    private static final class_7919 REFRESH_INFO = class_7919.method_47407((class_2561)class_2561.method_43471((String)"cursors_extended.options.refresh.info"));
    private static final class_2960 EXIT_SPRITE = CursorsExtended.loc("textures/gui/sprites/icon/caret_right.png");
    private static final class_2960 CLEAR_SPRITE = CursorsExtended.loc("textures/gui/sprites/icon/cross.png");
    private static final class_2960 REFRESH_SPRITE = CursorsExtended.loc("textures/gui/sprites/icon/arrow_clockwise.png");
    private final class_437 previous;
    private final int headerHeight;
    private final int sidebarWidth;
    private final int maxContentWidth;
    private final int spacing;
    private final Map<CatalogItem, ItemContext> items = new LinkedHashMap<CatalogItem, ItemContext>();
    private class_342 searchField;
    private ButtonWidget clearButton;
    private ItemList catalog;
    private ButtonWidget doneButton;
    private ButtonWidget refreshButton;
    private ContentPanel contents;
    private String previousSearch = "";

    protected CatalogBrowserScreen(class_2561 title, int headerHeight, int sidebarWidth, int maxContentWidth, int spacing, class_437 previous) {
        super(title);
        this.headerHeight = headerHeight;
        this.sidebarWidth = sidebarWidth;
        this.maxContentWidth = maxContentWidth;
        this.spacing = spacing;
        this.previous = previous;
    }

    protected void initItems() {
    }

    protected void postInit() {
    }

    protected final void method_25426() {
        this.doneButton = (ButtonWidget)this.method_37063((class_364)new ButtonWidget(class_5244.field_24334, this::method_25419).withSize(20).withTooltip(class_5244.field_24334).spriteOnly(EXIT_SPRITE));
        this.clearButton = new ButtonWidget(class_5244.field_39003, this::clearSearch).withSize(20).withTooltip(CLEAR_SEARCH_INFO).spriteOnly(CLEAR_SPRITE);
        this.clearButton.field_22763 = false;
        this.searchField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.sidebarWidth - this.clearButton.method_25368() - this.spacing, this.headerHeight, SEARCH_TEXT));
        this.searchField.method_47404(SEARCH_TEXT);
        this.searchField.method_1863(this::search);
        this.method_37063((class_364)this.clearButton);
        this.catalog = (ItemList)this.method_37063((class_364)new ItemList(this.field_22787, this.field_22793, this.sidebarWidth, this.spacing, this::onItemChange));
        this.refreshButton = (ButtonWidget)this.method_37063((class_364)new ButtonWidget(class_5244.field_39003, this::refreshItemsAndPanel).withSize(20).withTooltip(REFRESH_INFO).spriteOnly(REFRESH_SPRITE));
        this.initItems();
        this.refreshItems();
        this.method_48640();
        this.postInit();
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.previous);
        }
    }

    public void method_25432() {
        if (this.contents != null) {
            this.contents.removed();
        }
    }

    protected final void method_48640() {
        int contentsWidth = this.getContentWidth();
        int usableWidth = this.sidebarWidth + this.spacing + contentsWidth;
        int maxOffsetX = this.field_22789 - usableWidth - this.spacing;
        int leftColumnX = Math.max(this.spacing, Math.min((this.field_22789 - usableWidth) / 2, maxOffsetX));
        int rightColumnX = leftColumnX + this.sidebarWidth + this.spacing;
        if (this.doneButton != null && this.refreshButton != null) {
            this.doneButton.method_48229(rightColumnX + contentsWidth - this.doneButton.method_25368(), this.spacing);
            this.refreshButton.method_48229(this.doneButton.method_46426() - this.refreshButton.method_25368() - this.spacing, this.spacing);
        }
        if (this.searchField != null && this.clearButton != null) {
            this.searchField.method_48229(leftColumnX, this.spacing);
            this.clearButton.method_48229(this.searchField.method_55442() + this.spacing, this.spacing);
        }
        if (this.catalog != null) {
            this.catalog.method_53533(this.field_22790 - this.spacing * 2 - (this.headerHeight + this.spacing));
            this.catalog.method_48229(leftColumnX, this.spacing + this.headerHeight + this.spacing);
            this.catalog.clampScrollAmount();
        }
        if (this.contents != null) {
            this.contents.setWidth(contentsWidth);
            this.contents.setHeight(this.field_22790 - this.spacing * 2);
            this.contents.method_48229(rightColumnX, this.spacing);
            this.contents.repositionElements();
        }
    }

    protected int getContentWidth() {
        int totalWidth = this.field_22789 - this.spacing * 2;
        return this.maxContentWidth <= 0 ? totalWidth - this.sidebarWidth - this.spacing : Math.min(this.maxContentWidth, totalWidth - this.sidebarWidth - this.spacing);
    }

    protected void selectItem(@Nullable CatalogItem item) {
        if (item != null) {
            this.catalog.select(item);
        } else {
            this.catalog.select((CatalogItem)null);
            if (this.contents != null) {
                this.method_37066((class_364)this.contents);
                this.contents.removed();
                this.contents = null;
            }
        }
    }

    private void onItemChange(CatalogItem item) {
        ItemContext itemContext = this.items.get(item);
        if (itemContext == null) {
            throw new NullPointerException("CatalogItem " + item.id() + " context not found.");
        }
        ContentPanel contentPanel = itemContext.contents();
        if (contentPanel != this.contents) {
            if (this.contents != null) {
                this.method_37066((class_364)this.contents);
                this.contents.removed();
            }
            this.contents = contentPanel;
            this.contents.changedItem(this.previousSearch, itemContext.category(), item);
            this.method_37063((class_364)this.contents);
            this.contents.added(this.previousSearch);
        } else {
            this.contents.changedItem(this.previousSearch, itemContext.category(), item);
        }
        this.method_48640();
    }

    protected CatalogItem addCategory(@NotNull CatalogItem category, boolean collapsible, boolean collapsed) {
        this.catalog.addCategory(Objects.requireNonNull(category), new CategoryContext(collapsible, collapsed));
        return category;
    }

    protected CatalogItem addCategory(@NotNull CatalogItem category) {
        return this.addCategory(category, true, false);
    }

    protected void addCategoryOnly(@NotNull CatalogItem category, @NotNull ContentPanel panel) {
        this.addCategory(category, false, true);
        this.items.put(category, new ItemContext(category, this.initPanel(panel)));
    }

    protected void addItem(@NotNull CatalogItem category, @NotNull CatalogItem item, @NotNull ContentPanel panel) {
        if (this.items.containsKey(Objects.requireNonNull(category))) {
            throw new IllegalStateException("Category " + category.id() + " is already an item.");
        }
        this.items.put(Objects.requireNonNull(item), new ItemContext(category, this.initPanel(panel)));
        this.catalog.addItem(category, item);
    }

    protected void updateItem(@NotNull CatalogItem item, @NotNull ContentPanel contentPanel) {
        ItemContext oldContext = this.items.get(item);
        if (oldContext == null) {
            throw new IllegalStateException("CatalogItem " + item.id() + " has not beed added.");
        }
        ItemContext context = Objects.requireNonNull(this.items.computeIfPresent(item, (i, ctx) -> new ItemContext(ctx.category(), this.initPanel(contentPanel))));
        this.items.replace(item, context);
        this.catalog.replaceItem(context.category(), item);
        if (this.contents != null && this.contents == oldContext.contents() && item.equals(this.contents.getItem())) {
            if (oldContext.contents() != context.contents()) {
                boolean isFocused = this.method_25399() == this.contents;
                this.method_37066((class_364)this.contents);
                this.contents.removed();
                this.contents = context.contents();
                if (isFocused) {
                    this.method_25395((class_364)this.contents);
                }
                this.contents.changedItem(this.previousSearch, context.category(), item);
                this.method_37063((class_364)this.contents);
                this.contents.added(this.previousSearch);
            } else {
                this.contents.changedItem(this.previousSearch, context.category(), item);
            }
            this.method_48640();
        }
    }

    protected void addOrUpdateItem(@NotNull CatalogItem category, @NotNull CatalogItem item, @NotNull ContentPanel panel) {
        if (this.items.containsKey(item)) {
            this.updateItem(item, panel);
        } else {
            this.addItem(category, item, panel);
        }
    }

    protected void refreshItems() {
        this.catalog.refreshEntries();
    }

    protected void refreshItemsAndPanel() {
        this.refreshItems();
        if (this.contents != null) {
            this.contents.removed();
            this.contents.added();
        }
        this.method_48640();
    }

    protected class_4185 getRefreshButton() {
        return this.refreshButton;
    }

    private ContentPanel initPanel(ContentPanel panel) {
        panel.init(this.field_22787, this.field_22793, this, this.headerHeight, this.getContentWidth() - this.doneButton.method_25368() - this.refreshButton.method_25368() - this.spacing * 2, this.spacing);
        return panel;
    }

    protected void focusPath(class_364 child) {
        this.method_48267();
        class_8016.method_48194((class_364)child, (class_4069[])new class_4069[]{this}).method_48195(true);
    }

    protected boolean autoFocusSearch() {
        return true;
    }

    public boolean method_25400(class_11905 charEvent) {
        if (super.method_25400(charEvent)) {
            return true;
        }
        if (this.autoFocusSearch() && charEvent.comp_4793() != 32 && this.searchField != null && !this.searchField.method_25370()) {
            this.focusPath((class_364)this.searchField);
            return this.searchField.method_25400(charEvent);
        }
        return false;
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (super.method_25404(keyEvent)) {
            return true;
        }
        if (this.autoFocusSearch() && keyEvent.comp_4795() == 259 && this.searchField != null && !this.searchField.method_25370() && !this.searchField.method_1882().isEmpty()) {
            this.focusPath((class_364)this.searchField);
            return this.searchField.method_25404(keyEvent);
        }
        return false;
    }

    private void clearSearch() {
        if (this.searchField != null) {
            this.searchField.method_1852("");
        }
    }

    private void search(String search) {
        if (this.clearButton != null) {
            boolean bl = this.clearButton.field_22763 = !search.isEmpty();
        }
        if (Objects.equals(this.previousSearch, search)) {
            return;
        }
        this.previousSearch = search;
        if (search.isEmpty()) {
            this.catalog.filterItems(null);
            this.refreshItems();
            if (this.contents != null) {
                this.contents.searched(search, null);
            }
        } else {
            SearchResult result = this.performSearch(search.toLowerCase());
            this.catalog.filterItems(result.visibleItems());
            if (result.firstResult() != null) {
                this.selectItem(result.firstResult());
            }
            this.refreshItems();
            if (this.contents != null) {
                this.contents.searched(search, result.firstMatch());
            }
        }
    }

    private SearchResult performSearch(String lowercaseSearch) {
        HashMap<CatalogItem, Set<CatalogItem>> visibleItems = new HashMap<CatalogItem, Set<CatalogItem>>();
        CatalogItem firstResult = null;
        class_2561 firstMatch = null;
        for (Map.Entry<CatalogItem, ItemContext> itemEntry : this.items.entrySet()) {
            ItemContext context;
            CatalogItem item = itemEntry.getKey();
            MatchResult matchResult = this.findMatch(item, context = itemEntry.getValue(), lowercaseSearch);
            if (!matchResult.hasMatch()) continue;
            if (firstResult == null) {
                firstResult = item;
                firstMatch = matchResult.matchedText();
            }
            visibleItems.computeIfAbsent(context.category(), k -> new HashSet()).add(item);
        }
        return new SearchResult(visibleItems, firstResult, firstMatch);
    }

    private MatchResult findMatch(CatalogItem item, ItemContext context, String lowercaseSearch) {
        class_2561 matchedText = CatalogBrowserScreen.containsStringLowerCase(context.contents().indexed, lowercaseSearch);
        if (matchedText != null) {
            return new MatchResult(true, matchedText);
        }
        if (CatalogBrowserScreen.containsStringLowerCase(item.text(), lowercaseSearch)) {
            return new MatchResult(true, null);
        }
        if (CatalogBrowserScreen.containsStringLowerCase(context.category().text(), lowercaseSearch)) {
            return new MatchResult(true, null);
        }
        return new MatchResult(false, null);
    }

    private static boolean containsStringLowerCase(class_2561 text, String string) {
        return text.method_27662().getString().toLowerCase().contains(string);
    }

    @Nullable
    private static class_2561 containsStringLowerCase(List<class_2561> texts, String string) {
        for (class_2561 text : texts) {
            if (!CatalogBrowserScreen.containsStringLowerCase(text, string)) continue;
            return text;
        }
        return null;
    }

    private static class ItemList
    extends AbstractListWidget<AbstractItemEntry> {
        private static final int UNPADDED_HEIGHT = 8;
        private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF);
        private final ElementSlidingBackground selectedBackground = new ElementSlidingBackground(0x33FFFFFF);
        private final ElementSlidingBackground focusedBackground = new ElementSlidingBackground(-1, true);
        private final Map<CatalogItem, CategoryContext> categories = new LinkedHashMap<CatalogItem, CategoryContext>();
        private final Map<CatalogItem, Set<CatalogItem>> visibleItems = new HashMap<CatalogItem, Set<CatalogItem>>();
        private final Consumer<CatalogItem> onSelect;
        private final class_327 font;
        private final int spacing;
        private boolean searching;
        @Nullable
        private CatalogItem selectedItem;

        private ItemList(class_310 minecraft, class_327 font, int width, int spacing, Consumer<CatalogItem> onSelect) {
            super(minecraft, width, 0, 0, 8 + spacing * 2);
            this.onSelect = onSelect;
            this.font = font;
            this.spacing = spacing;
        }

        private void addCategory(CatalogItem category, CategoryContext context) {
            this.categories.put(category, context);
        }

        private void addItem(CatalogItem category, CatalogItem item) {
            CategoryContext context = this.categories.computeIfAbsent(category, c -> new CategoryContext());
            context.items().add(item);
        }

        private void replaceItem(@NotNull CatalogItem category, @NotNull CatalogItem item) {
            int index = this.indexOf(category, item);
            if (index == -1) {
                throw new IllegalStateException("CatalogItem " + item.id() + " has not beed added.");
            }
            this.categories.get(category).items().set(index, item);
        }

        private int indexOf(@NotNull CatalogItem category, @Nullable CatalogItem item) {
            CategoryContext context = this.categories.get(category);
            if (context != null) {
                List<CatalogItem> items = context.items();
                for (int i = 0; i < items.size(); ++i) {
                    if (!Objects.equals(items.get(i), item)) continue;
                    return i;
                }
            }
            return -1;
        }

        private void filterItems(@Nullable Map<CatalogItem, Set<CatalogItem>> visibleItems) {
            this.visibleItems.clear();
            boolean bl = this.searching = visibleItems != null;
            if (this.searching) {
                this.visibleItems.putAll(visibleItems);
            }
        }

        private void refreshEntries() {
            AbstractItemEntry focusedEntry = (AbstractItemEntry)this.method_25336();
            AbstractItemEntry selectedEntry = (AbstractItemEntry)this.method_25334();
            this.method_25339();
            this.method_25395(null);
            for (Map.Entry<CatalogItem, CategoryContext> categoryContexts : this.categories.entrySet()) {
                if (this.searching && !this.visibleItems.containsKey(categoryContexts.getKey())) continue;
                CategoryContext categoryContext = categoryContexts.getValue();
                CatalogItem categoryItem = categoryContexts.getKey().withText(text -> text.method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true)))).withPrefix(CategoryEntry.applyCollapsibleSymbol(categoryContext));
                CategoryEntry categoryEntry = new CategoryEntry(this, this.font, categoryItem, categoryContext.collapsible(), this.spacing);
                this.method_25321((class_350.class_351)categoryEntry);
                if (categoryContext.collapsed()) continue;
                Set<CatalogItem> items = this.visibleItems.get(categoryItem);
                for (CatalogItem item : categoryContexts.getValue().items()) {
                    if (this.searching && (items == null || !items.isEmpty() && !items.contains(item))) continue;
                    ItemEntry selectableEntry = new ItemEntry(this, this.font, item, this.spacing);
                    this.method_25321((class_350.class_351)selectableEntry);
                }
            }
            this.method_25395((class_364)focusedEntry);
            if (focusedEntry != selectedEntry) {
                this.setSelected(selectedEntry);
            }
            this.clampScrollAmount();
        }

        private void select(CatalogItem item, @Nullable AbstractItemEntry itemEntry) {
            if (this.selectedItem == null || !this.selectedItem.equals(item)) {
                this.selectedItem = item;
                this.method_25395((class_364)itemEntry);
                if (itemEntry != null) {
                    this.method_73377((class_350.class_351)itemEntry);
                }
                this.onSelect.accept(this.selectedItem);
            }
        }

        private void select(AbstractItemEntry itemEntry) {
            this.select(itemEntry.getItem(), itemEntry);
        }

        private void select(@Nullable CatalogItem item) {
            if (item != null) {
                this.select(item, this.getEntryFromItem(item));
            } else {
                this.selectedItem = null;
            }
        }

        private void toggleCategory(AbstractItemEntry itemEntry) {
            if (!(itemEntry instanceof CategoryEntry)) {
                throw new IllegalArgumentException("Entry is not an instance of CategoryEntry");
            }
            CategoryEntry categoryEntry = (CategoryEntry)itemEntry;
            CatalogItem category = categoryEntry.getItem();
            CategoryContext context = this.categories.computeIfPresent(category, (c, ctx) -> ctx.toggle());
            this.method_25395((class_364)categoryEntry);
            this.refreshEntries();
            AbstractItemEntry focused = (AbstractItemEntry)this.method_25336();
            if (focused != null) {
                focused.method_25395((class_364)focused.button);
            }
            if (context != null && !context.collapsed() && this.indexOf(category, this.selectedItem) == -1) {
                this.select(context.items().getFirst());
            }
        }

        @Nullable
        private AbstractItemEntry getEntryFromItem(@Nullable CatalogItem item) {
            if (item != null) {
                for (AbstractItemEntry entry : this.method_25396()) {
                    if (!entry.getItem().equals(item)) continue;
                    return entry;
                }
            }
            return null;
        }

        private void renderSlidingBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.hoveredBackground.render(guiGraphics, (class_8021)this.method_25308(mouseX, mouseY), partialTick);
            this.selectedBackground.render(guiGraphics, (class_8021)this.getEntryFromItem(this.selectedItem), partialTick);
            this.focusedBackground.render(guiGraphics, (class_8021)this.method_25336(), partialTick);
        }

        public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
            this.focusedBackground.reset();
            this.selectedBackground.reset();
            return super.method_25401(mouseX, mouseY, scrollX, scrollY);
        }

        public void method_25311(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderSlidingBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.method_25311(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void method_25395(@Nullable class_364 focused) {
            if (focused instanceof AbstractItemEntry) {
                AbstractItemEntry itemEntry = (AbstractItemEntry)((Object)focused);
                focused = this.getEntryFromItem(itemEntry.getItem());
            }
            super.method_25395(focused);
        }

        public void setSelected(@Nullable AbstractItemEntry selected) {
            if (selected != null) {
                selected = this.getEntryFromItem(selected.getItem());
            }
            super.method_25313((class_350.class_351)selected);
        }

        private abstract class AbstractItemEntry
        extends AbstractListWidget.Entry {
            protected final class_327 font;
            protected final CatalogItem item;
            protected final ItemButton button;
            protected final List<ItemButton> children;

            protected AbstractItemEntry(ItemList itemList, class_327 font, CatalogItem item, int spacing, Consumer<AbstractItemEntry> onClick) {
                super(itemList);
                this.font = font;
                this.item = item;
                this.button = new ItemButton(this.item, this.font, spacing, itemButton -> onClick.accept(this));
                this.children = Collections.singletonList(this.button);
            }

            CatalogItem getItem() {
                return this.item;
            }

            public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
                this.button.method_55445(this.method_25368(), this.method_25364());
                this.button.method_48229(this.method_46426(), this.method_46427());
                this.button.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }

            public void method_25365(boolean focused) {
                super.method_25365(focused);
                class_364 focusedElement = this.method_25399();
                if (focusedElement != null) {
                    focusedElement.method_25365(focused);
                }
            }

            @NotNull
            public List<ItemButton> method_25396() {
                return this.children;
            }

            @NotNull
            public List<ItemButton> method_37025() {
                return this.children;
            }
        }

        private class CategoryEntry
        extends AbstractItemEntry {
            private static final class_2561 COLLAPSED_SYMBOL = CategoryEntry.wrapSymbol("\u25b6");
            private static final class_2561 COLLAPSIBLE_SYMBOL = CategoryEntry.wrapSymbol("\u25bc");
            private static final class_2561 NON_COLLAPSIBLE_SYMBOL = CategoryEntry.wrapSymbol("\u25a0");
            private static final int SYMBOL_COLOR = -1;

            private CategoryEntry(ItemList itemList, class_327 font, CatalogItem item, boolean collapsible, int spacing) {
                super(itemList, font, item, spacing, collapsible ? itemList::toggleCategory : itemList::select);
            }

            private static class_2561 wrapSymbol(String symbol) {
                return class_2561.method_43470((String)symbol).method_27694(style -> style.method_10982(Boolean.valueOf(true)));
            }

            private static UnaryOperator<CatalogItem.Prefix> applyCollapsibleSymbol(CategoryContext context) {
                class_2561 symbol = !context.collapsible() ? NON_COLLAPSIBLE_SYMBOL : (context.collapsed() ? COLLAPSED_SYMBOL : COLLAPSIBLE_SYMBOL);
                return prefix -> {
                    if (prefix != null) {
                        return prefix;
                    }
                    return (guiGraphics, font, item, bounds, spacing, mouseX, mouseY, partialTick) -> {
                        int x = bounds.method_46426() + spacing;
                        int n = bounds.method_46427();
                        int n2 = bounds.method_25364();
                        Objects.requireNonNull(font);
                        int y = n + (n2 - 9) / 2;
                        int width = Math.max(font.method_27525((class_5348)NON_COLLAPSIBLE_SYMBOL), Math.max(font.method_27525((class_5348)COLLAPSED_SYMBOL), font.method_27525((class_5348)COLLAPSIBLE_SYMBOL)));
                        int endX = x + width;
                        Objects.requireNonNull(font);
                        int endY = y + 9;
                        DrawUtil.drawScrollableTextLeftAlign(guiGraphics, font, symbol, x, y, endX, endY, -1);
                        return width;
                    };
                };
            }
        }

        private class ItemEntry
        extends AbstractItemEntry {
            private ItemEntry(ItemList itemList, class_327 font, CatalogItem item, int spacing) {
                super(itemList, font, item, spacing, itemList::select);
            }
        }
    }

    public static abstract class ContentPanel
    extends class_362
    implements class_4068,
    class_6379,
    class_8021 {
        private final List<class_2561> indexed = new ArrayList<class_2561>();
        private final List<class_364> children = new ArrayList<class_364>();
        private final List<class_4068> renderables = new ArrayList<class_4068>();
        private final List<class_6379> narratables = new ArrayList<class_6379>();
        private int x;
        private int y;
        private int width;
        private int height;
        private class_6379 lastNarratable;
        private CatalogItem item;
        private CatalogItem category;
        private boolean initialized;
        private int spacing;
        private int headerHeight;
        private int headerWidth;
        private class_310 minecraft;
        private class_327 font;
        private CatalogBrowserScreen catalog;
        @NotNull
        private String search = "";

        protected void added() {
        }

        protected void removed() {
        }

        protected void changed(@NotNull CatalogItem category, @NotNull CatalogItem item) {
        }

        protected void searched(@NotNull String search, @Nullable class_2561 matched) {
        }

        protected void repositionElements() {
        }

        protected abstract void init();

        private void init(class_310 minecraft, class_327 font, CatalogBrowserScreen catalog, int headerHeight, int headerWidth, int spacing) {
            if (!this.initialized) {
                this.initialized = true;
                this.minecraft = minecraft;
                this.font = font;
                this.catalog = catalog;
                this.spacing = spacing;
                this.headerHeight = headerHeight;
                this.headerWidth = headerWidth;
                this.init();
            }
        }

        private void added(@NotNull String search) {
            this.search = search;
            this.added();
        }

        private void changedItem(@NotNull String search, @NotNull CatalogItem category, @NotNull CatalogItem item) {
            this.category = Objects.requireNonNull(category);
            this.item = Objects.requireNonNull(item);
            this.search = search;
            this.changed(this.category, this.item);
        }

        protected void clearWidgets() {
            this.indexed.clear();
            this.children.clear();
            this.renderables.clear();
            this.narratables.clear();
        }

        protected class_2561 index(class_2561 text) {
            this.indexed.add(text);
            return text;
        }

        protected <T extends class_4068 & class_364> void addRenderableWidget(T widget) {
            this.children.add(widget);
            this.narratables.add((class_6379)widget);
            this.renderables.add(widget);
        }

        protected void addRenderableIndexedWidget(class_339 widget) {
            this.addRenderableWidget(widget);
            this.indexed.add(widget.method_25369());
        }

        protected final void changeItem(CatalogItem item) {
            this.catalog.selectItem(item);
        }

        protected CatalogBrowserScreen getScreen() {
            return this.catalog;
        }

        protected class_310 getMinecraft() {
            return this.minecraft;
        }

        protected class_327 getFont() {
            return this.font;
        }

        public CatalogItem getItem() {
            return this.item;
        }

        public CatalogItem getCategory() {
            return this.category;
        }

        @NotNull
        public String getSearch() {
            return this.search;
        }

        public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            for (class_4068 renderable : this.renderables) {
                renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.method_25368()) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.method_25364());
        }

        @NotNull
        public List<class_364> method_25396() {
            return this.children;
        }

        public void method_46421(int x) {
            this.x = x;
        }

        public void method_46419(int y) {
            this.y = y;
        }

        public int method_46426() {
            return this.x;
        }

        public int method_46427() {
            return this.y;
        }

        private void setWidth(int width) {
            this.width = width;
        }

        public int method_25368() {
            return this.width;
        }

        private void setHeight(int height) {
            this.height = height;
        }

        public int method_25364() {
            return this.height;
        }

        public int getRight() {
            return this.method_46426() + this.method_25368();
        }

        public int getBottom() {
            return this.method_46427() + this.method_25364();
        }

        public int getSpacing() {
            return this.spacing;
        }

        public int getHeaderHeight() {
            return this.headerHeight;
        }

        public int getHeaderWidth() {
            return this.headerWidth;
        }

        @NotNull
        public class_8030 method_48202() {
            return super.method_48202();
        }

        public void method_48206(Consumer<class_339> consumer) {
            for (class_364 child : this.children) {
                if (!(child instanceof class_339)) continue;
                class_339 widget = (class_339)child;
                consumer.accept(widget);
            }
        }

        @NotNull
        public final class_6379.class_6380 method_37018() {
            return this.method_25370() ? class_6379.class_6380.field_33786 : class_6379.class_6380.field_33784;
        }

        public final void method_37020(@NotNull class_6382 narrationElementOutput) {
            List<class_6379> sortedNarratables = this.narratables.stream().filter(class_6379::method_37303).sorted(Comparator.comparingInt(class_8083::method_48590)).toList();
            class_437.class_6390 narratableSearchResult = class_437.method_37061(sortedNarratables, (class_6379)this.lastNarratable);
            if (narratableSearchResult != null) {
                if (narratableSearchResult.comp_4465().method_37028()) {
                    this.lastNarratable = narratableSearchResult.comp_4463();
                }
                if (sortedNarratables.size() > 1 && narratableSearchResult.comp_4465() == class_6379.class_6380.field_33786) {
                    narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
                }
                narratableSearchResult.comp_4463().method_37020(narrationElementOutput.method_37031());
            }
        }
    }

    private record ItemContext(@NotNull CatalogItem category, @NotNull ContentPanel contents) {
        private ItemContext(@NotNull CatalogItem category, @NotNull ContentPanel contents) {
            Objects.requireNonNull(category);
            Objects.requireNonNull(contents);
        }
    }

    private record CategoryContext(boolean collapsible, boolean collapsed, @NotNull List<CatalogItem> items) {
        private CategoryContext(boolean collapsible, boolean collapsed, @NotNull List<CatalogItem> items) {
            Objects.requireNonNull(items);
        }

        public CategoryContext(boolean collapsible, boolean collapsed) {
            this(collapsible, collapsed, new ArrayList<CatalogItem>());
        }

        public CategoryContext() {
            this(true, false, new ArrayList<CatalogItem>());
        }

        private CategoryContext toggle() {
            if (!this.collapsible) {
                throw new IllegalStateException("Cannot collapse non-collapsible category");
            }
            return new CategoryContext(true, !this.collapsed, this.items);
        }
    }

    private record SearchResult(Map<CatalogItem, Set<CatalogItem>> visibleItems, @Nullable CatalogItem firstResult, @Nullable class_2561 firstMatch) {
    }

    private record MatchResult(boolean hasMatch, class_2561 matchedText) {
    }

    private static class ItemButton
    extends class_4264 {
        private static final int TEXT_COLOR = -1;
        private final Consumer<ItemButton> onClick;
        private final CatalogItem item;
        private final class_327 font;
        private final int spacing;

        public ItemButton(CatalogItem item, class_327 font, int spacing, Consumer<ItemButton> onClick) {
            super(0, 0, 0, 0, item.text());
            this.font = font;
            this.item = item;
            this.spacing = spacing;
            this.onClick = Objects.requireNonNull(onClick);
        }

        public void method_25306(class_11907 inputWithModifiers) {
            this.onClick.accept(this);
        }

        protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            int prefixWidth;
            int n = prefixWidth = this.item.prefix() != null ? this.item.prefix().render(guiGraphics, this.font, this.item, (class_8021)this, this.spacing, mouseX, mouseY, partialTick) : 0;
            if (prefixWidth > 0) {
                prefixWidth += this.spacing;
            }
            int startX = this.method_46426() + this.spacing + prefixWidth;
            int n2 = this.method_46427();
            int n3 = this.method_25364();
            Objects.requireNonNull(this.font);
            int startY = n2 + (n3 - 9) / 2;
            int endX = this.method_55442() - this.spacing;
            Objects.requireNonNull(this.font);
            int endY = startY + 9;
            DrawUtil.drawScrollableTextLeftAlign(guiGraphics, this.font, this.method_25369(), startX, startY, endX, endY, -1);
            if (this.method_49606()) {
                guiGraphics.method_74037(class_11876.field_62455);
            }
        }

        protected void method_47399(@NotNull class_6382 narrationElementOutput) {
            narrationElementOutput.method_37034(class_6381.field_33788, this.method_25369());
        }
    }
}

