/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.mixin.compat.glfw;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.compat.CursorStateTracker;
import io.github.fishstiz.cursors_extended.compat.ModCursor;
import io.github.fishstiz.cursors_extended.compat.glfw.GLFWInternal;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import java.util.stream.Stream;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GLFW.class}, remap=false)
public abstract class GLFWMixin {
    @Unique
    private static final int MAX_SOURCE_PACKAGE_DEPTH = 4;

    @Unique
    private static String cursors_extended$getSourcePackage(Stream<StackWalker.StackFrame> frames) {
        return frames.dropWhile(frame -> frame.getDeclaringClass() == GLFW.class).findFirst().map(frame -> {
            String packageName = frame.getDeclaringClass().getPackageName();
            int count = 0;
            int index = -1;
            while ((index = packageName.indexOf(46, index + 1)) != -1) {
                if (++count != 4) continue;
                return packageName.substring(0, index);
            }
            return packageName;
        }).orElse("placeholder");
    }

    @WrapMethod(method={"glfwCreateStandardCursor"})
    private static long trackStandardCursor(int shape, Operation<Long> original) {
        long handle = (Long)original.call(new Object[]{shape});
        if (GLFWInternal.isCreatingStandardCursor() || CursorStateTracker.get().getCursor(handle) != null) {
            GLFWInternal.trackInternalCursor(handle);
            return handle;
        }
        String mapped = CursorTypeUtil.mapStandardCursorName(shape);
        if (mapped != null) {
            String sourcePackage = CursorStateTracker.getStackWalker().walk(GLFWMixin::cursors_extended$getSourcePackage);
            CursorStateTracker.get().trackCursor(new ModCursor(handle, sourcePackage, new class_11875(mapped, handle)));
        }
        return handle;
    }

    @WrapMethod(method={"nglfwCreateCursor"})
    private static long trackCustomCursor(long image, int xhot, int yhot, Operation<Long> original) {
        long handle = (Long)original.call(new Object[]{image, xhot, yhot});
        if (GLFWInternal.isCreatingCursor()) {
            GLFWInternal.trackInternalCursor(handle);
            return handle;
        }
        String sourcePackage = CursorStateTracker.getStackWalker().walk(GLFWMixin::cursors_extended$getSourcePackage);
        CursorStateTracker.get().trackCursor(ModCursor.ofUnknownType(handle, sourcePackage));
        CursorsExtended.LOGGER.info("[cursors_extended] Tracking custom cursor from '{}'", (Object)sourcePackage);
        return handle;
    }

    @Inject(method={"glfwDestroyCursor"}, at={@At(value="RETURN")})
    private static void untrackCursor(long cursor, CallbackInfo ci) {
        GLFWInternal.untrackInternalCursor(cursor);
        ModCursor modCursor = CursorStateTracker.get().getCursor(cursor);
        if (modCursor != null) {
            CursorStateTracker.get().untrackCursor(modCursor);
        }
    }

    @WrapMethod(method={"glfwSetCursor"})
    private static void setMappedCursor(long window, long cursor, Operation<Void> original) {
        CursorStateTracker tracker = CursorStateTracker.get();
        if (GLFWInternal.isSettingCursor() || GLFWInternal.isInternalCursor(cursor) || !tracker.isTracking()) {
            original.call(new Object[]{window, cursor});
            return;
        }
        CursorRegistry registry = CursorsExtended.getInstance().getRegistry();
        if (cursor == 0L) {
            tracker.resetCursor(window, CursorStateTracker.getStackWalker().walk(GLFWMixin::cursors_extended$getSourcePackage));
            original.call(new Object[]{window, CursorsExtended.CONFIG.isRemapStandardCursors() ? registry.get(class_11875.field_62449).handle() : 0L});
            CursorStateTracker.syncWithMinecraft(window, class_11875.field_62449);
            return;
        }
        ModCursor modCursor = tracker.getCursor(cursor);
        if (modCursor == null) {
            original.call(new Object[]{window, cursor});
            return;
        }
        tracker.setCursor(window, modCursor);
        if (modCursor.custom() || !CursorsExtended.CONFIG.isRemapStandardCursors()) {
            original.call(new Object[]{window, cursor});
            CursorStateTracker.syncWithMinecraft(window, modCursor.cursorType());
            return;
        }
        Cursor mapped = registry.get(modCursor.cursorType());
        if (!mapped.isEnabled()) {
            mapped = registry.get(class_11875.field_62449);
        }
        if (window != CursorsExtended.getInstance().getDisplay().getWindow().method_4490()) {
            CursorsExtended.getInstance().getLoader().lazyLoadTexture(mapped);
            original.call(new Object[]{window, mapped.handle()});
        }
    }

    static {
        CursorsExtended.LOGGER.debug("[cursors_extended] Loading CursorTypes: {}", class_11876.class);
    }
}

