package io.github.fishstiz.cursors_extended.gui.screen;

import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.gui.screen.panel.*;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_11875;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_8021;

public class ConfigurationScreen extends CatalogBrowserScreen {
    private static final class_2561 GLOBAL_TEXT = class_2561.method_43471("cursors_extended.options.global");
    private static final class_2561 ADAPTIVE_TEXT = class_2561.method_43471("cursors_extended.options.adapt");
    private static final class_2561 COMPAT_TEXT = class_2561.method_43471("cursors_extended.options.compat");
    private static final class_2561 CURSORS_TEXT = class_2561.method_43471("cursors_extended.options.cursor-types");
    private static final class_2561 DEBUG_TEXT = class_2561.method_43471("cursors_extended.options.debug");
    private static final int SPACING = 8;
    private static final int HEADER_HEIGHT = 20;
    private static final int SIDEBAR_WIDTH = 140;
    private static final int MAX_CONTENT_WIDTH = 128 * 2 + SPACING;
    private static final int LIST_CURSOR_SIZE = 16;
    private static final CatalogItem GLOBAL_CATEGORY = new CatalogItem("global", GLOBAL_TEXT);
    private static final CatalogItem CURSORS_CATEGORY = new CatalogItem("cursors", CURSORS_TEXT);
    private CatalogItem defaultItem;
    private CompletableFuture<Void> refreshFuture;

    public ConfigurationScreen(class_437 previous) {
        super(class_2561.method_43471("cursors_extended.options"), HEADER_HEIGHT, SIDEBAR_WIDTH, MAX_CONTENT_WIDTH, SPACING, previous);
    }

    @Override
    public void method_49589() {
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getInternalCursors()) {
            if (cursor.isLazy()) {
                CursorsExtended.getInstance().getLoader().loadTexture(cursor);
            }
        }
    }

    @Override
    public void method_25419() {
        CursorsExtended.CONFIG.save();
        super.method_25419();
    }

    @Override
    protected void initItems() {
        this.addGlobalItems();
        this.addAdaptiveItems();
        this.addCategory(CURSORS_CATEGORY, true, !CursorsExtended.CONFIG.hasResourcePack());
        this.addCursorItems();
        this.addCompatibilityItems();
        this.addDebugItems();
    }

    @Override
    protected void postInit() {
        this.selectItem(this.defaultItem);
    }

    @Override
    protected void refreshItemsAndPanel() {
        if (this.refreshFuture != null && !this.refreshFuture.isDone()) {
            return;
        }

        this.getRefreshButton().field_22763 = false;
        this.refreshFuture = CompletableFuture
                .runAsync(CursorsExtended.getInstance().getLoader()::reload, class_156.method_18349())
                .whenCompleteAsync((result, error) -> {
                    if (error != null) {
                        CursorsExtended.LOGGER.error("[cursors_extended] An error occurred while refreshing cursors. {}", error.getMessage());
                    }

                    this.addCursorItems();
                    super.refreshItemsAndPanel();
                    this.getRefreshButton().field_22763 = true;
                }, this.field_22787);
    }

    private void addGlobalItems() {
        this.addCategoryOnly(GLOBAL_CATEGORY, new GlobalOptionsPanel(this::refreshCursors));
    }

    private void addAdaptiveItems() {
        CatalogItem category = new CatalogItem("adaptive", ADAPTIVE_TEXT);
        this.defaultItem = category;
        this.addCategoryOnly(category, new AdaptiveOptionsPanel(ADAPTIVE_TEXT, this::refreshCursors));
    }

    private void addCompatibilityItems() {
        this.addCategoryOnly(new CatalogItem("compatibility", COMPAT_TEXT), new CompatibilityOptionsPanel(COMPAT_TEXT));
    }

    private void addCursorItems() {
        for (CatalogItem cursorItem : this.createCursorItems()) {
            if (class_11875.field_62449.toString().equals(cursorItem.id()) && CursorsExtended.CONFIG.hasResourcePack()) {
                this.defaultItem = cursorItem;
            }

            this.addOrUpdateItem(CURSORS_CATEGORY, cursorItem, new CursorOptionsPanel(
                    this::refreshCursors,
                    GLOBAL_CATEGORY,
                    Objects.requireNonNull(CursorsExtended.getInstance().getRegistry().tryGet(cursorItem.id()))
            ));
        }
    }

    private void addDebugItems() {
        this.addCategoryOnly(new CatalogItem("debug", DEBUG_TEXT), new DebugOptionsPanel(DEBUG_TEXT));
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);

        if (this.refreshFuture != null && !this.refreshFuture.isDone()) {
            guiGraphics.method_74037(CursorTypesExt.BUSY);
        }
    }

    private int renderListCursor(class_332 guiGraphics, class_327 font, CatalogItem item, class_8021 bounds, int spacing, int mouseX, int mouseY, float partialTick) {
        Cursor cursor = CursorsExtended.getInstance().getRegistry().tryGet(item.id());

        if (cursor != null && cursor.getTexture() != null) {
            int prefixX = bounds.method_46426() + spacing;
            int prefixY = bounds.method_46427() + (bounds.method_25364() - LIST_CURSOR_SIZE) / 2;
            DrawUtil.drawCursor(guiGraphics, cursor, prefixX, prefixY, LIST_CURSOR_SIZE);
        }

        return LIST_CURSOR_SIZE;
    }

    private void refreshCursors() {
        this.addCursorItems();
        this.refreshItems();
    }

    private List<CatalogItem> createCursorItems() {
        return CursorsExtended.getInstance().getRegistry().getInternalCursors()
                .stream()
                .map(cursor -> new CatalogItem(
                        cursor.name(),
                        cursor.text().method_27661().method_27692(getCursorFormat(cursor)),
                        this::renderListCursor
                ))
                .toList();
    }

    private static class_124 getCursorFormat(@NotNull Cursor cursor) {
        if (cursor.isTextureEnabled()) {
            return class_124.field_1068;
        }
        if (cursor.hasTexture()) {
            return class_124.field_1080;
        }
        return class_124.field_1063;
    }
}
