package io.github.fishstiz.cursors_extended.util;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

import java.util.Objects;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;

public class CursorTypeUtil {
    private CursorTypeUtil() {
    }

    public static boolean nameEquals(class_11875 a, class_11875 b) {
        return Objects.equals(a.toString(), b.toString());
    }

    public static boolean canShift() {
        Cursor shiftCursor = CursorsExtended.getInstance().getRegistry().get(CursorTypesExt.SHIFT);
        return CursorsExtended.CONFIG.getOrCreateSettings(shiftCursor).enabled() &&
               (class_3675.method_15987(class_310.method_1551().method_22683(), GLFW.GLFW_KEY_LEFT_SHIFT) ||
                class_3675.method_15987(class_310.method_1551().method_22683(), GLFW.GLFW_KEY_RIGHT_SHIFT));
    }

    public static boolean isLeftClickHeld() {
        return GLFW.glfwGetMouseButton(class_310.method_1551().method_22683().method_4490(), GLFW.GLFW_MOUSE_BUTTON_1) == GLFW.GLFW_PRESS;
    }

    public static boolean isHeld(class_11875 lastCursorType) {
        return CursorTypesExt.isHoldType(lastCursorType) &&
               CursorsExtended.CONFIG.getOrCreateSettings(CursorsExtended.getInstance().getRegistry().get(lastCursorType)).enabled() &&
               CursorTypeUtil.isLeftClickHeld();
    }

    public static boolean nonDefault(class_11875 cursorType) {
        return cursorType != null && !nameEquals(cursorType, class_11875.field_62449);
    }

    public static class_11875 arrowIfDefault(class_11875 cursorType) {
        return nameEquals(cursorType, class_11875.field_62449) ? class_11876.field_62452 : cursorType;
    }

    public static boolean isHovered(class_364 guiEventListener, double mouseX, double mouseY) {
        if (guiEventListener instanceof class_339 widget) {
            return widget.field_22764 &&
                   widget.method_49606() &&
                   mouseX >= widget.method_46426() &&
                   mouseY >= widget.method_46427() &&
                   mouseX < widget.method_55442() &&
                   mouseY < widget.method_55443();
        }
        return guiEventListener.method_25405(mouseX, mouseY);
    }

    public static @Nullable class_11875 mapStandardCursor(int shape) {
        return switch (shape) {
            case GLFW.GLFW_ARROW_CURSOR -> class_11875.field_62449;
            case GLFW.GLFW_POINTING_HAND_CURSOR -> class_11876.field_62455;
            case GLFW.GLFW_IBEAM_CURSOR -> class_11876.field_62453;
            case GLFW.GLFW_CROSSHAIR_CURSOR -> class_11876.field_62454;
            case GLFW.GLFW_RESIZE_EW_CURSOR -> class_11876.field_62457;
            case GLFW.GLFW_RESIZE_NS_CURSOR -> class_11876.field_62456;
            case GLFW.GLFW_RESIZE_NWSE_CURSOR -> CursorTypesExt.RESIZE_NWSE;
            case GLFW.GLFW_RESIZE_NESW_CURSOR -> CursorTypesExt.RESIZE_NESW;
            case GLFW.GLFW_RESIZE_ALL_CURSOR -> class_11876.field_62458;
            case GLFW.GLFW_NOT_ALLOWED_CURSOR -> class_11876.field_62459;
            default -> null;
        };
    }

    public static @Nullable String mapStandardCursorName(int shape) {
        return switch (shape) {
            case GLFW.GLFW_ARROW_CURSOR -> "default";
            case GLFW.GLFW_POINTING_HAND_CURSOR -> "pointing_hand";
            case GLFW.GLFW_IBEAM_CURSOR -> "ibeam";
            case GLFW.GLFW_CROSSHAIR_CURSOR -> "crosshair";
            case GLFW.GLFW_RESIZE_EW_CURSOR -> "resize_ew";
            case GLFW.GLFW_RESIZE_NS_CURSOR -> "resize_ns";
            case GLFW.GLFW_RESIZE_NWSE_CURSOR -> "resize_nwse";
            case GLFW.GLFW_RESIZE_NESW_CURSOR -> "resize_nesw";
            case GLFW.GLFW_RESIZE_ALL_CURSOR -> "resize_all";
            case GLFW.GLFW_NOT_ALLOWED_CURSOR -> "not_allowed";
            default -> null;
        };
    }
}
