/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.cursor.TexturedCursorType;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import org.jetbrains.annotations.Nullable;

public class CursorRegistry {
    private final Map<String, Cursor> registry = new Object2ObjectLinkedOpenHashMap();
    private volatile Map<String, Cursor> external;
    private Map<String, Cursor> custom;

    public void onInitRenderSystem() {
        this.register(class_11875.field_62449);
        this.registerAlias(class_11875.field_62449, class_11876.field_62452);
        this.register(class_11876.field_62455);
        this.register(CursorTypesExt.GRABBING);
        this.register(class_11876.field_62453);
        this.register(CursorTypesExt.SHIFT);
        this.register(CursorTypesExt.BUSY);
        this.register(class_11876.field_62459);
        this.register(class_11876.field_62454);
        this.register(class_11876.field_62458);
        this.register(class_11876.field_62457);
        this.register(class_11876.field_62456);
        this.register(CursorTypesExt.RESIZE_NWSE);
        this.register(CursorTypesExt.RESIZE_NESW);
    }

    public void register(class_11875 cursorType) {
        this.registry.putIfAbsent(cursorType.toString(), new Cursor(cursorType));
    }

    public void registerAlias(class_11875 cursorType, class_11875 alias) {
        this.registry.putIfAbsent(alias.toString(), this.get(cursorType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor get(class_11875 cursorType) {
        Cursor cursor = this.registry.get(cursorType.toString());
        if (cursor != null) {
            return cursor;
        }
        CursorRegistry cursorRegistry = this;
        synchronized (cursorRegistry) {
            Object2ObjectOpenHashMap map = ((TexturedCursorType)cursorType).cursors_extended$isCustom() ? (this.custom == null ? (this.custom = new Object2ObjectOpenHashMap()) : this.custom) : (this.external == null ? (this.external = new Object2ObjectOpenHashMap()) : this.external);
            return map.computeIfAbsent(cursorType.toString(), name -> {
                CursorsExtended.LOGGER.info("[cursors_extended] Found external cursor type: {}", (Object)cursorType);
                return new Cursor(cursorType);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCustom(class_11875 cursorType) {
        CursorRegistry cursorRegistry = this;
        synchronized (cursorRegistry) {
            if (this.custom != null) {
                this.custom.remove(cursorType.toString());
            }
        }
    }

    @Nullable
    public Cursor tryGet(String cursorType) {
        Cursor cursor = this.registry.get(cursorType);
        return cursor != null || this.external == null ? cursor : this.external.get(cursorType);
    }

    public Set<Cursor> getCursors() {
        ObjectOpenHashSet cursors = new ObjectOpenHashSet();
        cursors.addAll(this.registry.values());
        if (this.external != null) {
            cursors.addAll(this.external.values());
        }
        return cursors;
    }

    public Set<Cursor> getInternalCursors() {
        return new ObjectLinkedOpenHashSet(this.registry.values());
    }
}

