/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorProvider;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public abstract class CursorWidget
extends class_339
implements CursorProvider {
    public static final int DEFAULT_HEIGHT = 32;
    public static final int DEFAULT_WIDTH = 32;
    private static final int BACKGROUND_SIZE = 128;
    private static final int BORDER_COLOR = -16777216;
    private static final int FOCUSED_BORDER_COLOR = -1;
    private final class_2960 background128;
    private final Cursor cursor;
    private boolean renderRuler = true;

    protected CursorWidget(int x, int y, int width, int height, @NotNull class_2561 message, @NotNull Cursor cursor, @NotNull class_2960 background128) {
        super(x, y, width, height, message);
        this.cursor = cursor;
        this.background128 = background128;
    }

    protected CursorWidget(@NotNull class_2561 message, @NotNull Cursor cursor, @NotNull class_2960 background128) {
        this(0, 0, 32, 32, message, cursor, background128);
    }

    protected void renderCursor(@NotNull class_332 guiGraphics, @NotNull Cursor cursor) {
    }

    protected abstract void renderRuler(@NotNull class_332 var1, int var2, int var3);

    protected void renderBackground(@NotNull class_332 guiGraphics) {
        if (!this.isOverflowing()) {
            DrawUtil.drawCheckerboard(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.getCellWidth(), this.getCellHeight(), this.background128, 128);
        }
    }

    protected void renderBorder(@NotNull class_332 guiGraphics) {
        int color = this.method_25370() && this.field_22763 ? -1 : -16777216;
        DrawUtil.renderOutline(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), color);
    }

    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.cursor.hasTexture()) {
            this.renderBackground(guiGraphics);
            this.renderCursor(guiGraphics, this.cursor);
            if (this.isRenderRuler()) {
                this.renderRuler(guiGraphics, mouseX, mouseY);
            }
        }
        this.renderBorder(guiGraphics);
    }

    public void setRenderRuler(boolean renderRuler) {
        this.renderRuler = renderRuler;
    }

    public boolean isRenderRuler() {
        return this.renderRuler;
    }

    @NotNull
    protected Cursor getCursor() {
        return this.cursor;
    }

    protected float getCellWidth() {
        CursorTexture texture = this.getCursor().getTexture();
        if (texture == null) {
            return 0.0f;
        }
        int spriteWidth = texture.spriteWidth();
        int spriteHeight = texture.spriteHeight();
        float scale = (float)this.method_25368() / (float)Math.max(spriteWidth, spriteHeight);
        int drawWidth = Math.round((float)spriteWidth * scale);
        return (float)drawWidth / (float)spriteWidth;
    }

    protected float getCellHeight() {
        CursorTexture texture = this.getCursor().getTexture();
        if (texture == null) {
            return 0.0f;
        }
        int spriteWidth = texture.spriteWidth();
        int spriteHeight = texture.spriteHeight();
        float scale = (float)this.method_25364() / (float)Math.max(spriteWidth, spriteHeight);
        int drawHeight = Math.round((float)spriteHeight * scale);
        return (float)drawHeight / (float)spriteHeight;
    }

    protected boolean isOverflowing() {
        CursorTexture texture = this.getCursor().getTexture();
        return texture == null || texture.spriteWidth() > 128 || texture.spriteHeight() > 128;
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }
}

