/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.util.DrawUtil;
import net.minecraft.class_156;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8021;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementSlidingBackground {
    private static final float ANIMATION_SPEED = 25.0f;
    private final boolean outlineOnly;
    private final int color;
    private float lastY = 0.0f;
    private long lastFrameTime = class_156.method_648();

    public ElementSlidingBackground(int color, boolean outlineOnly) {
        this.color = color;
        this.outlineOnly = outlineOnly;
    }

    public ElementSlidingBackground(int color) {
        this(color, false);
    }

    public void reset() {
        this.lastY = 0.0f;
        this.lastFrameTime = class_156.method_648();
    }

    public void render(@NotNull class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        long now = class_156.method_648();
        float deltaTime = (float)(now - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = now;
        float f = this.lastY = this.lastY == 0.0f ? (float)y : this.lastY;
        if (Math.abs(this.lastY - (float)y) < 0.5f) {
            this.lastY = y;
        } else {
            float alpha = 1.0f - (float)Math.exp(-25.0f * deltaTime);
            this.lastY = class_3532.method_16439((float)alpha, (float)this.lastY, (float)y);
        }
        int right = x + width;
        int bottom = (int)this.lastY + height;
        if (this.outlineOnly) {
            DrawUtil.renderOutline(guiGraphics, x, (int)this.lastY, width, height, this.color);
        } else {
            guiGraphics.method_25294(x, (int)this.lastY, right, bottom, this.color);
        }
    }

    public void render(@NotNull class_332 guiGraphics, @Nullable class_8021 element, float partialTick) {
        if (element == null) {
            this.reset();
            return;
        }
        this.render(guiGraphics, element.method_46426(), element.method_46427(), element.method_25368(), element.method_25364(), partialTick);
    }
}

