/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.compat.CursorStateTracker;
import io.github.fishstiz.cursors_extended.compat.WindowCursor;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.resource.texture.AnimatedCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.class_1041;
import net.minecraft.class_11875;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_1041.class})
public abstract class WindowMixin
implements WindowCursor {
    @Shadow
    @Final
    private long field_5187;
    @Shadow
    public class_11875 field_62448;
    @Shadow
    private boolean field_62447;
    @Unique
    private long cursors_extended$currentCursorHandle;

    @ModifyExpressionValue(method={"selectCursor"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="currentCursor", field={"Lcom/mojang/blaze3d/platform/Window;currentCursor:Lcom/mojang/blaze3d/platform/cursor/CursorType;"}), @Definition(id="cursorType", local={@Local(type=class_11875.class, ordinal=1)})})
    @Expression(value={"this.currentCursor != cursorType"})
    private boolean checkHasChanged(boolean original, @Local(ordinal=1) class_11875 cursorType) {
        Cursor cursor = CursorsExtended.getInstance().getRegistry().get(cursorType);
        if (original) {
            CursorTexture cursorTexture = cursor.getTexture();
            if (cursorTexture instanceof AnimatedCursorTexture) {
                AnimatedCursorTexture animatedCursorTexture = (AnimatedCursorTexture)cursorTexture;
                animatedCursorTexture.restartAnimation();
            }
            return true;
        }
        if (CursorsExtended.CONFIG.isAggressiveCursor()) {
            return true;
        }
        return cursor.handle() != this.cursors_extended$currentCursorHandle;
    }

    @ModifyVariable(method={"selectCursor"}, at=@At(value="HEAD"), argsOnly=true)
    private class_11875 resolveSelected(class_11875 value) {
        class_11875 cursorType = this.cursors_extended$resolveCursor(value);
        Cursor cursor = CursorsExtended.getInstance().getRegistry().get(cursorType);
        CursorsExtended.getInstance().getLoader().lazyLoadTexture(cursor);
        return !cursor.isTextureEnabled() && !cursor.isCustom() && CursorsExtended.CONFIG.hasResourcePack() ? class_11875.field_62449 : cursorType;
    }

    @WrapOperation(method={"selectCursor"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/cursor/CursorType;select(Lcom/mojang/blaze3d/platform/Window;)V")})
    private void onSelect(class_11875 instance, class_1041 window, Operation<Void> original) {
        Cursor cursor = CursorsExtended.getInstance().getRegistry().get(instance);
        this.cursors_extended$currentCursorHandle = cursor.handle();
        CursorsExtended.getInstance().getDisplay().applyCursor(window);
    }

    @Override
    public void cursors_extended$setCurrentCursor(class_11875 cursorType) {
        Cursor cursor = CursorsExtended.getInstance().getRegistry().get(cursorType);
        this.field_62448 = cursor.cursorType();
        this.cursors_extended$currentCursorHandle = cursor.handle();
    }

    @Unique
    private class_11875 cursors_extended$resolveCursor(class_11875 requestedCursor) {
        class_11875 cursorType;
        class_11875 currentTrackedCursor;
        CursorStateTracker tracker = CursorStateTracker.get();
        if (tracker.isTracking() && CursorTypeUtil.nonDefault(currentTrackedCursor = tracker.getCurrentCursor(this.field_5187))) {
            return currentTrackedCursor;
        }
        if (!this.field_62447) {
            return class_11875.field_62449;
        }
        if (CursorTypeUtil.isHeld(this.field_62448)) {
            return this.field_62448;
        }
        if (CursorTypeUtil.nonDefault(requestedCursor)) {
            return requestedCursor;
        }
        if (CursorsExtended.CONFIG.isLegacyMode() && CursorTypeUtil.nonDefault(cursorType = CursorsExtended.getInstance().getDisplay().getCursorAt((class_1041)this))) {
            return cursorType;
        }
        return class_11875.field_62449;
    }
}

