/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.mixin.compat.glfw;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.compat.CursorStateTracker;
import io.github.fishstiz.cursors_extended.compat.ModCursor;
import io.github.fishstiz.cursors_extended.compat.glfw.GLFWInternal;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.platform.Services;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import java.util.stream.Stream;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={GLFW.class}, remap=false, priority=5000)
public abstract class GLFWMixin {
    @Unique
    private static final int MAX_SOURCE_PACKAGE_DEPTH = 4;

    @Unique
    private static String cursors_extended$getSourcePackage(Stream<StackWalker.StackFrame> frames) {
        return frames.dropWhile(frame -> frame.getDeclaringClass() == GLFW.class).findFirst().map(frame -> {
            String packageName = frame.getDeclaringClass().getPackageName();
            int count = 0;
            int index = -1;
            while ((index = packageName.indexOf(46, index + 1)) != -1) {
                if (++count != 4) continue;
                return packageName.substring(0, index);
            }
            return packageName;
        }).orElse("placeholder");
    }

    @WrapMethod(method={"glfwCreateStandardCursor"})
    private static long trackStandardCursor(int shape, Operation<Long> original) {
        long handle = (Long)original.call(new Object[]{shape});
        if (GLFWInternal.isCreatingStandardCursor() || CursorStateTracker.get().getCursor(handle) != null) {
            return handle;
        }
        String name = CursorTypeUtil.mapStandardCursorName(shape);
        if (name != null) {
            String sourcePackage = CursorStateTracker.getStackWalker().walk(GLFWMixin::cursors_extended$getSourcePackage);
            CursorStateTracker.get().trackCursor(new ModCursor(handle, sourcePackage, name));
            if (Services.PLATFORM.isDevelopmentEnvironment()) {
                CursorsExtended.LOGGER.info("[cursors_extended] tracking standard cursor handle: {}={}, from {}", new Object[]{name, handle, sourcePackage});
            }
        }
        return handle;
    }

    @WrapMethod(method={"nglfwCreateCursor"})
    private static long trackCustomCursor(long image, int xhot, int yhot, Operation<Long> original) {
        long handle = (Long)original.call(new Object[]{image, xhot, yhot});
        if (GLFWInternal.isCreatingCursor() || CursorStateTracker.get().getCursor(handle) != null) {
            return handle;
        }
        String sourcePackage = CursorStateTracker.getStackWalker().walk(GLFWMixin::cursors_extended$getSourcePackage);
        CursorStateTracker.get().trackCursor(ModCursor.createCustom(handle, sourcePackage));
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            CursorsExtended.LOGGER.info("[cursors_extended] tracking custom cursor handle: {}, from {}", (Object)handle, (Object)sourcePackage);
        }
        return handle;
    }

    @WrapMethod(method={"glfwDestroyCursor"})
    private static void untrackCursor(long cursor, Operation<Void> original) {
        original.call(new Object[]{cursor});
        ModCursor modCursor = CursorStateTracker.get().getCursor(cursor);
        if (modCursor != null) {
            CursorStateTracker.get().untrackCursor(modCursor);
            CursorsExtended.getInstance().getRegistry().unregisterCustom(modCursor.cursorType());
        }
    }

    @WrapMethod(method={"glfwSetCursor"})
    private static void setMappedCursor(long window, long cursor, Operation<Void> original) {
        CursorStateTracker tracker = CursorStateTracker.get();
        if (!tracker.isTracking() && cursor != 0L) {
            original.call(new Object[]{window, cursor});
            return;
        }
        ModCursor modCursor = tracker.getCursor(cursor);
        boolean internal = GLFWInternal.isSettingCursor();
        boolean reentry = GLFWInternal.consumeReentryCursor(window, cursor);
        if (internal || reentry || modCursor == null) {
            if (!reentry && internal) {
                GLFWInternal.markReentryCursor(window, cursor);
            }
            if (!internal && cursor == 0L) {
                boolean remap = CursorsExtended.CONFIG.isRemapStandardCursors();
                if (!remap) {
                    CursorStateTracker.syncWithMinecraft(window, class_11875.field_62449);
                }
                tracker.resetCursor(window, CursorStateTracker.getStackWalker().walk(GLFWMixin::cursors_extended$getSourcePackage));
                if (remap && !reentry) {
                    return;
                }
            }
            original.call(new Object[]{window, cursor});
            return;
        }
        if (!CursorsExtended.CONFIG.isRemapStandardCursors()) {
            CursorStateTracker.syncWithMinecraft(window, modCursor.cursorType());
            tracker.setCursor(window, modCursor);
            original.call(new Object[]{window, cursor});
            return;
        }
        CursorRegistry registry = CursorsExtended.getInstance().getRegistry();
        Cursor mapped = registry.get(modCursor.cursorType());
        if (!modCursor.custom() && !CursorsExtended.CONFIG.getOrCreateSettings(mapped).enabled()) {
            mapped = registry.get(class_11875.field_62449);
            tracker.resetCursor(window, modCursor.source());
        } else {
            tracker.setCursor(window, modCursor);
        }
        if (window != CursorsExtended.getInstance().getDisplay().getWindow().method_4490()) {
            CursorsExtended.getInstance().getLoader().lazyLoadTexture(mapped);
            original.call(new Object[]{window, mapped.handle()});
        }
    }

    static {
        CursorsExtended.LOGGER.debug("[cursors_extended] Loading CursorTypes: {}", class_11876.class);
    }
}

