/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.resource;

import com.google.common.hash.Hashing;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.config.Config;
import io.github.fishstiz.cursors_extended.config.CursorMetadata;
import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.config.JsonLoader;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.lifecycle.ClientStartedListener;
import io.github.fishstiz.cursors_extended.resource.texture.AnimatedCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.AnimationState;
import io.github.fishstiz.cursors_extended.resource.texture.BasicCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1011;
import net.minecraft.class_11875;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorTextureLoader
implements class_3302,
ClientStartedListener {
    private final Map<String, CursorMetadata> preparedMetadata = new Object2ObjectOpenHashMap();
    private final CursorRegistry registry;
    private class_310 minecraft;
    private boolean prepared;

    public CursorTextureLoader(CursorRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void onClientStarted(class_310 minecraft) {
        this.minecraft = minecraft;
    }

    @NotNull
    public CompletableFuture<Void> method_25931(class_3302.class_11558 sharedState, Executor backgroundExecutor, class_3302.class_4045 preparationBarrier, Executor gameExecutor) {
        this.prepared = false;
        return CompletableFuture.runAsync(() -> this.prepare(sharedState.method_72361()), backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0));
    }

    public void reload() {
        this.prepare(this.minecraft.method_1478());
        this.loadTextures(this.registry.getCursors());
    }

    private Optional<String> prepareMetadataHash(class_3300 manager, Iterable<Cursor> hashableCursors) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (Cursor cursor : hashableCursors) {
            class_2960 path = CursorTextureLoader.getExpectedPath(cursor.cursorType());
            if (path == null) {
                CursorsExtended.LOGGER.error("[cursors_extended] Invalid resource location path for cursor '{}' while computing hash.", (Object)cursor.name());
                continue;
            }
            manager.method_14486(path.method_48331(".json")).ifPresentOrElse(resource -> {
                try {
                    CursorMetadata metadata = this.loadMetadata(manager, path, resource.method_14480());
                    this.preparedMetadata.put(cursor.name(), metadata);
                    out.write(resource.method_14480().getBytes(StandardCharsets.UTF_8));
                    CursorTextureLoader.writeBytes(out, metadata);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, () -> this.preparedMetadata.put(cursor.name(), new CursorMetadata()));
        }
        return out.size() == 0 ? Optional.empty() : Optional.of(Hashing.murmur3_32_fixed().hashBytes(out.toByteArray()).toString());
    }

    private void prepare(class_3300 manager) {
        this.preparedMetadata.clear();
        boolean dirty = this.prepareMetadataHash(manager, this.registry.getInternalCursors()).map(hash -> {
            boolean changed;
            boolean bl = changed = !Objects.equals(CursorsExtended.CONFIG.getHash(), hash);
            if (changed) {
                CursorsExtended.LOGGER.info("[cursors_extended] Resource pack hash has changed, updating config...");
                CursorsExtended.CONFIG.setHash((String)hash);
                CursorsExtended.CONFIG.getGlobal().setActiveAll(false);
                CursorsExtended.CONFIG.markSettingsStale();
            }
            return changed;
        }).orElseGet(() -> {
            boolean changed = CursorsExtended.CONFIG.getHash() != null && !CursorsExtended.CONFIG.getHash().isEmpty();
            CursorsExtended.LOGGER.info("[cursors_extended] No resource pack detected.");
            CursorsExtended.CONFIG.setHash("");
            return changed;
        });
        for (Cursor cursor : this.registry.getCursors()) {
            if (cursor.isCustom()) continue;
            cursor.setLazy(true);
            CursorMetadata metadata = this.preparedMetadata.computeIfAbsent(cursor.name(), type -> {
                class_2960 path = CursorTextureLoader.getExpectedPath(cursor.cursorType());
                if (path == null) {
                    return new CursorMetadata();
                }
                return manager.method_14486(path.method_48331(".json")).map(resource -> this.loadMetadata(manager, path, resource.method_14480())).orElse(new CursorMetadata());
            });
            if (!CursorsExtended.CONFIG.isStale(cursor)) continue;
            CursorsExtended.CONFIG.getOrCreateSettings(cursor).mergeSelective(metadata.cursor());
            dirty = true;
        }
        this.prepared = true;
        if (dirty) {
            CursorsExtended.CONFIG.save();
        }
    }

    public void releaseTexture(Cursor cursor) {
        CursorTexture texture = cursor.getTexture();
        if (texture != null) {
            texture.close();
            cursor.setTexture(null);
            if (this.minecraft != null) {
                this.minecraft.execute(() -> this.minecraft.method_1531().method_4615(texture.comp_3627()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTexture(class_3300 manager, Cursor cursor) {
        boolean loaded;
        block21: {
            if (!this.prepared) {
                return false;
            }
            class_2960 path = CursorTextureLoader.getExpectedPath(cursor.cursorType());
            if (path == null) {
                return false;
            }
            loaded = false;
            try (CursorTexture previousTexture = cursor.getTexture();){
                class_3298 resource = manager.method_14486(path).orElse(null);
                if (resource == null) break block21;
                try (InputStream in = resource.method_14482();
                     class_1011 image = class_1011.method_4309((InputStream)in);){
                    SettingsUtil.assertImageSize(image.method_4307(), image.method_4323());
                    CursorMetadata metadata = this.preparedMetadata.getOrDefault(cursor.name(), this.loadMetadata(manager, path, resource.method_14480()));
                    Config.CursorSettings settings = CursorsExtended.CONFIG.getGlobal().apply(CursorsExtended.CONFIG.getOrCreateSettings(cursor));
                    CursorTexture texture = metadata.animation() != null ? new AnimatedCursorTexture(AnimationState.of(metadata.animation().mode()), image, path, metadata, settings) : new BasicCursorTexture(image, path, metadata, settings);
                    cursor.setTexture(texture);
                    this.minecraft.execute(() -> this.minecraft.method_1531().method_4615(path));
                    loaded = true;
                }
            }
        }
        if (!loaded) {
            this.releaseTexture(cursor);
        }
        cursor.setLazy(false);
        return loaded;
    }

    public boolean loadTexture(Cursor cursor) {
        return this.loadTexture(this.minecraft.method_1478(), cursor);
    }

    private void loadTextures(class_3300 manager, Collection<Cursor> cursors) {
        for (Cursor cursor : cursors) {
            this.loadTexture(manager, cursor);
        }
    }

    public void lazyLoadTexture(Cursor cursor) {
        if (cursor.isCustom()) {
            return;
        }
        Cursor cursor2 = cursor = CursorsExtended.CONFIG.getOrCreateSettings(cursor).enabled() ? cursor : this.registry.get(class_11875.field_62449);
        if (CursorsExtended.CONFIG.getOrCreateSettings(cursor).enabled() && cursor.isLazy()) {
            this.loadTexture(cursor);
        }
    }

    public void loadTextures(Collection<Cursor> cursors) {
        this.loadTextures(this.minecraft.method_1478(), cursors);
    }

    public void updateTexture(Cursor cursor, float scale, int xhot, int yhot) {
        CursorTexture texture = cursor.getTexture();
        if (texture == null) {
            return;
        }
        Config.CursorSettings settings = CursorsExtended.CONFIG.getOrCreateSettings(cursor).copy();
        settings.setScale(scale);
        settings.setXHot(cursor, xhot);
        settings.setYHot(cursor, yhot);
        try {
            CursorTexture updatedTexture = texture.recreate(settings);
            cursor.setTexture(updatedTexture);
            texture.close();
        }
        catch (Exception e) {
            CursorsExtended.LOGGER.error("[cursors_extended] Failed to update texture of cursor '{}'.", (Object)cursor.cursorType(), (Object)e);
            cursor.setTexture(texture);
        }
    }

    public void updateTexture(Cursor cursor, CursorProperties settings) {
        this.updateTexture(cursor, settings.scale(), settings.xhot(), settings.yhot());
    }

    private CursorMetadata loadMetadata(class_3300 manager, class_2960 location, String source) {
        return manager.method_14489(location.method_48331(".json")).stream().filter(metadata -> metadata.method_14480().equals(source)).findFirst().map(metadata -> JsonLoader.fromResource(CursorMetadata.class, metadata)).orElse(new CursorMetadata());
    }

    private static void writeBytes(ByteArrayOutputStream out, CursorMetadata metadata) throws IOException {
        CursorMetadata.Animation anim;
        CursorMetadata.CursorSettings cs = metadata.cursor();
        out.write(Float.toString(cs.scale()).getBytes(StandardCharsets.UTF_8));
        out.write(Integer.toString(cs.xhot()).getBytes(StandardCharsets.UTF_8));
        out.write(Integer.toString(cs.yhot()).getBytes(StandardCharsets.UTF_8));
        out.write(Boolean.toString(cs.enabled()).getBytes(StandardCharsets.UTF_8));
        if (cs.animated() != null) {
            out.write(Boolean.toString(cs.animated()).getBytes(StandardCharsets.UTF_8));
        }
        if ((anim = metadata.animation()) != null) {
            out.write(anim.mode().name().getBytes(StandardCharsets.UTF_8));
            out.write(Integer.toString(anim.frametime()).getBytes(StandardCharsets.UTF_8));
            if (anim.width() != null) {
                out.write(Integer.toString(anim.width()).getBytes(StandardCharsets.UTF_8));
            }
            if (anim.height() != null) {
                out.write(Integer.toString(anim.height()).getBytes(StandardCharsets.UTF_8));
            }
            for (CursorMetadata.Animation.Frame f : anim.frames()) {
                out.write(Integer.toString(f.index()).getBytes(StandardCharsets.UTF_8));
                out.write(Integer.toString(f.clampedTime(anim)).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    @Nullable
    private static class_2960 getExpectedPath(class_11875 cursorType) {
        String name = cursorType.toString();
        return class_2960.method_20208((String)name) ? CursorTextureLoader.getDir().method_48331("/" + name + ".png") : null;
    }

    public static class_2960 getDir() {
        return CursorsExtended.loc("textures/gui/sprites/cursors");
    }
}

