/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.resource.texture;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.config.CursorMetadata;
import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.resource.texture.AbstractCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.AnimationState;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.NativeImageUtil;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public final class AnimatedCursorTexture
implements CursorTexture {
    private final AnimationState animationState;
    private final Frame fallback;
    private final Frame[] frames;
    private final class_2960 texturePath;
    private final CursorMetadata metadata;
    private final float scale;
    private final int xhot;
    private final int yhot;
    private final int textureWidth;
    private final int textureHeight;
    private final byte[] pixels;
    private boolean animated;

    public AnimatedCursorTexture(AnimationState animationState, class_1011 image, class_2960 path, CursorMetadata metadata, CursorProperties settings) throws IOException {
        CursorMetadata.Animation animation = metadata.requireAnimation();
        int imageWidth = image.method_4307();
        int imageHeight = image.method_4323();
        int preferredFrameSize = Math.min(imageWidth, imageHeight);
        int frameWidth = Math.min(Math.abs(Objects.requireNonNullElse(animation.width(), preferredFrameSize)), imageWidth);
        int frameHeight = Math.min(Math.abs(Objects.requireNonNullElse(animation.height(), preferredFrameSize)), imageHeight);
        SettingsUtil.assertImageSize(frameWidth, frameHeight);
        int availableFrames = imageHeight / frameHeight;
        ObjectArrayList textures = new ObjectArrayList(availableFrames);
        try {
            for (int i = 0; i < availableFrames; ++i) {
                int yOffset = i * frameHeight;
                try (class_1011 croppedImage = NativeImageUtil.cropImage(image, 0, yOffset, frameWidth, frameHeight);){
                    textures.add(new Sprite(yOffset, croppedImage, settings));
                    continue;
                }
            }
            this.fallback = new Frame((Sprite)textures.getFirst(), animation.frametime());
            this.frames = (Frame[])AnimatedCursorTexture.createAnimationFrames(animation, (List<Sprite>)textures, availableFrames).toArray(Frame[]::new);
        }
        catch (Exception e) {
            textures.forEach(CursorTexture::close);
            throw e;
        }
        this.animated = settings.animated() == null || settings.animated() != false;
        this.metadata = metadata;
        this.animationState = animationState;
        this.texturePath = path;
        this.scale = SettingsUtil.sanitizeScale(settings.scale());
        this.xhot = SettingsUtil.sanitizeHotspot(settings.xhot(), image.method_4307());
        this.yhot = SettingsUtil.sanitizeHotspot(settings.yhot(), image.method_4323());
        this.textureWidth = imageWidth;
        this.textureHeight = imageHeight;
        this.pixels = NativeImageUtil.getBytes(image);
    }

    private static List<Frame> createAnimationFrames(CursorMetadata.Animation animation, List<Sprite> textures, int availableFrames) {
        ObjectArrayList frames = new ObjectArrayList();
        if (animation.frames().isEmpty()) {
            for (int i = 0; i < availableFrames; ++i) {
                frames.add(new Frame(textures.get(i), animation.frametime()));
            }
            return frames;
        }
        for (CursorMetadata.Animation.Frame frame : animation.frames()) {
            int index = frame.index();
            if (index < 0 || index >= availableFrames) {
                CursorsExtended.LOGGER.warn("[cursors_extended] Sprite does not exist on index {}.", (Object)index);
                continue;
            }
            frames.add(new Frame(textures.get(index), frame.clampedTime(animation)));
        }
        return frames;
    }

    @Override
    public long handle() {
        return this.currentFrame().sprite.handle();
    }

    @Override
    public float scale() {
        return this.scale;
    }

    @Override
    public int xhot() {
        return this.xhot;
    }

    @Override
    public int yhot() {
        return this.yhot;
    }

    @NotNull
    public Boolean animated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    @Override
    public int textureWidth() {
        return this.textureWidth;
    }

    @Override
    public int textureHeight() {
        return this.textureHeight;
    }

    @Override
    public int spriteWidth() {
        return this.currentFrame().sprite.spriteWidth();
    }

    @Override
    public int spriteHeight() {
        return this.currentFrame().sprite.spriteHeight();
    }

    @Override
    public int spriteVOffset() {
        return this.currentFrame().sprite.spriteVOffset();
    }

    @NotNull
    public class_2960 comp_3627() {
        return this.texturePath;
    }

    @Override
    public CursorMetadata metadata() {
        return this.metadata;
    }

    @Override
    public void close() {
        this.fallback.sprite.close();
        for (Frame frame : this.frames) {
            frame.sprite.close();
        }
    }

    public int frameCount() {
        return this.frames.length;
    }

    public Frame currentFrame() {
        return this.getFrame(this.animationState.next(this));
    }

    public Frame getFrame(int index) {
        if (!this.animated || this.frames.length == 0) {
            return this.fallback;
        }
        if (index < 0 || index >= this.frames.length) {
            return this.frames[0];
        }
        return this.frames[index];
    }

    public void restartAnimation() {
        this.animationState.reset();
    }

    @Override
    public CursorTexture recreate(CursorProperties properties) throws IOException {
        try (class_1011 image = class_1011.method_49277((byte[])this.pixels);){
            AnimatedCursorTexture animatedCursorTexture = new AnimatedCursorTexture(this.animationState, image, this.texturePath, this.metadata, properties);
            return animatedCursorTexture;
        }
    }

    public final class Sprite
    extends AbstractCursorTexture {
        private final int spriteWidth;
        private final int spriteHeight;
        private final int spriteVOffset;

        public Sprite(int vOffset, class_1011 image, CursorProperties properties) throws IOException {
            super(image, properties);
            this.spriteWidth = image.method_4307();
            this.spriteHeight = image.method_4323();
            this.spriteVOffset = vOffset;
        }

        @Override
        public int xhot() {
            return AnimatedCursorTexture.this.xhot;
        }

        @Override
        public int yhot() {
            return AnimatedCursorTexture.this.yhot;
        }

        @Override
        public float scale() {
            return AnimatedCursorTexture.this.scale;
        }

        @Override
        public int textureWidth() {
            return AnimatedCursorTexture.this.textureWidth;
        }

        @Override
        public int textureHeight() {
            return AnimatedCursorTexture.this.textureHeight;
        }

        @Override
        public int spriteWidth() {
            return this.spriteWidth;
        }

        @Override
        public int spriteHeight() {
            return this.spriteHeight;
        }

        @Override
        public int spriteVOffset() {
            return this.spriteVOffset;
        }

        @NotNull
        public class_2960 comp_3627() {
            return AnimatedCursorTexture.this.texturePath;
        }

        @Override
        public CursorMetadata metadata() {
            return AnimatedCursorTexture.this.metadata;
        }
    }

    public record Frame(Sprite sprite, int time) {
    }
}

