package io.github.fishstiz.minecraftcursor.compat.modmenu;

import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import io.github.fishstiz.minecraftcursor.api.CursorHandler;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import java.util.Optional;
import net.minecraft.class_364;

public class ModScreenCursorHandler implements CursorHandler<ModsScreen> {
    public static final int COMPACT_ICON_SIZE = 19;
    public static final int ICON_SIZE = 32;

    @Override
    public CursorType getCursorType(ModsScreen modsScreen, double mouseX, double mouseY) {
        Optional<class_364> hoveredElementOpt = modsScreen.method_19355(mouseX, mouseY);

        if (hoveredElementOpt.isEmpty()) {
            return CursorType.DEFAULT;
        }

        class_364 hoveredElement = hoveredElementOpt.get();
        if (!(hoveredElement instanceof ModListWidget modListWidget)) {
            return CursorType.DEFAULT;
        }

        if (ModMenuConfig.QUICK_CONFIGURE.getValue()) {
            int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? COMPACT_ICON_SIZE : ICON_SIZE;
            for (ModListEntry entry : modListWidget.method_25396()) {
                if (entry.method_25405(mouseX, mouseY)
                    && modsScreen.getModHasConfigScreen(entry.mod.getId())
                    && mouseX >= modListWidget.method_46426()
                    && mouseX - modListWidget.method_25342() <= iconSize)
                    return CursorType.POINTER;
            }
        }

        return CursorType.DEFAULT;
    }
}
