package io.github.fishstiz.minecraftcursor.mixin.cursorhandler;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3971;
import net.minecraft.class_3979;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_3979.class)
public abstract class StonecutterScreenMixin extends AbstractContainerScreenMixin<class_3971> {
    @Shadow
    @Final
    private static class_2960 RECIPE_HIGHLIGHTED_SPRITE;

    protected StonecutterScreenMixin(class_2561 title) {
        super(title);
    }

    @WrapOperation(method = "renderButtons", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V"
    ))
    private void setPointerOnHover(class_332 instance, class_2960 sprite, int x, int y, int width, int height, Operation<Void> original) {
        original.call(instance, sprite, x, y, width, height);
        if (MinecraftCursor.CONFIG.isStonecutterRecipesEnabled() && sprite == RECIPE_HIGHLIGHTED_SPRITE) {
            CursorController.getInstance().setSingleCycleFallbackCursor(CursorType.POINTER);
        }
    }
}
