package io.github.fishstiz.minecraftcursor.mixin.cursorhandler;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.handler.InternalCursorProvider;
import net.minecraft.class_310;
import net.minecraft.class_4280;
import net.minecraft.class_528;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_528.class)
public abstract class WorldSelectionListMixin extends class_4280<class_528.class_7414> implements InternalCursorProvider {
    @Unique
    private static final int minecraft_cursor$ICON_WIDTH = 32;

    protected WorldSelectionListMixin(class_310 minecraft, int width, int height, int y, int itemHeight) {
        super(minecraft, width, height, y, itemHeight);
    }

    @Override
    public @NotNull CursorType minecraft_cursor$getCursorType(double mouseX, double mouseY) {
        if (MinecraftCursor.CONFIG.isWorldIconEnabled()
            && mouseX < this.method_25342() + minecraft_cursor$ICON_WIDTH
            && this.method_25308(mouseX, mouseY) instanceof class_528.class_4272 worldEntry
            && worldEntry.method_54629()
        ) {
            return CursorType.POINTER;
        }
        return CursorType.DEFAULT;
    }
}
