package io.github.fishstiz.minecraftcursor.util;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.mixin.NativeImageAccess;
import org.lwjgl.system.MemoryUtil;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import net.minecraft.class_1011;

public class NativeImageUtil {
    private NativeImageUtil() {
    }

    public static class_1011 cropImage(class_1011 src, int xOffset, int yOffset, int width, int height) {
        int srcWidth = src.method_4307();
        int srcHeight = src.method_4323();

        if (xOffset < 0 || yOffset < 0 || xOffset + width > srcWidth || yOffset + height > srcHeight) {
            MinecraftCursor.LOGGER.error(
                    "[minecraft-cursor] Image size {}x{} is invalid. Valid size: {}x{} at y {}",
                    srcWidth, srcHeight, width, height, yOffset
            );
            return src;
        }

        class_1011 out = new class_1011(width, height, true);
        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                int color = src.method_4315(x + xOffset, y + yOffset);
                out.method_4305(x, y, color);
            }
        }

        return out;
    }

    public static class_1011 scaleImage(class_1011 src, double scale) {
        int width = (int) Math.round(src.method_4307() * scale);
        int height = (int) Math.round(src.method_4323() * scale);
        class_1011 scaled = new class_1011(width, height, true);

        for (int y = 0; y < height; y++) { // nearest neighbor
            for (int x = 0; x < width; x++) {
                int srcX = (int) (x / scale);
                int srcY = (int) (y / scale);
                scaled.method_4305(x, y, src.method_4315(srcX, srcY));
            }
        }
        return scaled;
    }

    public static void writePixelsRGBA(class_1011 image, ByteBuffer buffer) {
        int[] pixelsABGR = image.method_48463(); // its ABGR

        for (int abgr : pixelsABGR) {
            int a = (abgr >> 24) & 0xFF;
            int b = (abgr >> 16) & 0xFF;
            int g = (abgr >> 8) & 0xFF;
            int r = abgr & 0xFF;

            buffer.put((byte) r);
            buffer.put((byte) g);
            buffer.put((byte) b);
            buffer.put((byte) a);
        }

        buffer.flip();
    }

    public static class_1011 readLarge(byte[] bytes) throws IOException {
        ByteBuffer buffer = null;
        try {
            buffer = MemoryUtil.memAlloc(bytes.length);
            buffer.put(bytes);
            buffer.rewind();
            return class_1011.method_4324(buffer);
        } finally {
            if (buffer != null) {
                MemoryUtil.memFree(buffer);
            }
        }
    }

    public static byte[] getBytes(class_1011 image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(baos);

        boolean success = ((NativeImageAccess) (Object) image).invokeWriteToChannel(channel);
        channel.close();

        if (!success) throw new IOException("Failed to write NativeImage to PNG bytes.");

        return baos.toByteArray();
    }
}
