/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationState;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_332;

public class CursorAnimationHelper {
    private final Map<String, AnimationState> cursorStates = new HashMap<String, AnimationState>();

    public void reset(AnimatedCursor cursor) {
        AnimationState cursorState = this.cursorStates.get(cursor.getTypeKey());
        if (cursorState != null) {
            cursorState.reset();
        }
    }

    public void drawSprite(class_332 guiGraphics, Cursor cursor, int x, int y, int size) {
        if (cursor.isLoaded()) {
            int n;
            int cursorSize = cursor.getTextureWidth();
            if (cursor instanceof AnimatedCursor) {
                AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
                n = this.getCurrentSpriteIndex(animatedCursor);
            } else {
                n = 0;
            }
            float spriteIndex = n;
            RenderSystem.enableBlend();
            guiGraphics.method_25293(cursor.getLocation(), x, y, size, size, 0.0f, (float)cursorSize * spriteIndex, cursorSize, cursorSize, cursor.getTextureWidth(), cursor.getTextureHeight());
            RenderSystem.disableBlend();
        }
    }

    private int getCurrentSpriteIndex(AnimatedCursor cursor) {
        AnimationState state = this.cursorStates.computeIfAbsent(cursor.getType().getKey(), t -> new AnimationState());
        if (!cursor.isAnimated() || !cursor.isEnabled()) {
            state.reset();
            return cursor.getFallbackFrame().cursor().getTextureIndex();
        }
        return cursor.nextFrame(state).cursor().getTextureIndex();
    }
}

