/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.impl;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.CursorTypeRegistrar;
import io.github.fishstiz.minecraftcursor.api.ElementRegistrar;
import io.github.fishstiz.minecraftcursor.api.MinecraftCursorInitializer;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_3928;
import net.minecraft.class_4264;
import net.minecraft.class_434;
import net.minecraft.class_435;
import net.minecraft.class_7529;
import net.minecraft.class_8209;

public final class MinecraftCursorInitializerImpl
implements MinecraftCursorInitializer {
    public void init(CursorTypeRegistrar cursorRegistrar, ElementRegistrar elementRegistrar) {
        cursorRegistrar.register(new CursorType[]{CursorType.DEFAULT, CursorType.POINTER, CursorType.GRABBING, CursorType.TEXT, CursorType.SHIFT, CursorType.BUSY, CursorType.NOT_ALLOWED, CursorType.CROSSHAIR, CursorType.RESIZE_EW, CursorType.RESIZE_NS, CursorType.RESIZE_NWSE, CursorType.RESIZE_NESW});
        elementRegistrar.register(class_434.class, this::elementToBusy);
        elementRegistrar.register(class_435.class, this::elementToBusy);
        elementRegistrar.register(class_3928.class, this::elementToBusy);
        elementRegistrar.register(class_4264.class, this::buttonWidgetCursor);
        elementRegistrar.register(class_8209.class, this::tabButtonWidgetCursor);
        elementRegistrar.register(class_357.class, this::sliderWidgetCursor);
        elementRegistrar.register(class_342.class, this::textFieldWidgetCursor);
        elementRegistrar.register(class_7529.class, this::textFieldWidgetCursor);
    }

    private CursorType elementToBusy(class_364 ignoreElement, double ignoreMouseX, double ignoreMouseY) {
        return CursorType.BUSY;
    }

    private CursorType buttonWidgetCursor(class_4264 button, double mouseX, double mouseY) {
        if (button.field_22764 && button.method_49606()) {
            return MinecraftCursorInitializerImpl.inactiveButtonCursor((class_339)button);
        }
        return CursorType.DEFAULT;
    }

    private CursorType tabButtonWidgetCursor(class_8209 tabButton, double mouseX, double mouseY) {
        return tabButton.field_22763 && tabButton.field_22764 && tabButton.method_49606() && !tabButton.method_49611() ? CursorType.POINTER : CursorType.DEFAULT;
    }

    private CursorType sliderWidgetCursor(class_357 slider, double mouseX, double mouseY) {
        if (slider.method_25370() && (CursorTypeUtil.isLeftClickHeld() || CursorTypeUtil.isGrabbing())) {
            return CursorType.GRABBING;
        }
        return slider.field_22764 ? MinecraftCursorInitializerImpl.inactiveButtonCursor((class_339)slider) : CursorType.DEFAULT;
    }

    private CursorType textFieldWidgetCursor(class_339 textField, double mouseX, double mouseY) {
        return textField.field_22764 && textField.field_22763 && textField.method_49606() ? CursorType.TEXT : CursorType.DEFAULT;
    }

    private static CursorType inactiveButtonCursor(class_339 button) {
        if (button.field_22763) {
            return CursorType.POINTER;
        }
        if (MinecraftCursor.CONFIG.isInactiveWidgetsEnabled()) {
            return CursorType.NOT_ALLOWED;
        }
        return CursorType.DEFAULT;
    }
}

