package io.github.fishstiz.minecraftcursor.gui.screen.panel;

import io.github.fishstiz.minecraftcursor.cursor.resolver.CursorTypeResolver;
import io.github.fishstiz.minecraftcursor.gui.widget.ButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.OptionsListWidget;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_407;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugOptionsPanel extends AbstractOptionsPanel {
    private static final String CLEAR_CACHE_KEY = "minecraft-cursor.options.debug.cache.clear";
    private static final String ISSUES_LINK = "https://github.com/fishstiz/minecraft-cursor/issues";
    private static final String WIKI_LINK = "https://fishstiz.github.io/minecraft-cursor-wiki/resource-pack/getting-started";
    private static final class_2561 INSPECT_TEXT = class_2561.method_43471("minecraft-cursor.options.debug.inspect");
    private static final class_2561 CACHE_TEXT = class_2561.method_43470(class_2561.method_43471(CLEAR_CACHE_KEY).getString().replace("\\:.*", ""));
    private static final class_2561 REPORT_ISSUES_TEXT = class_2561.method_43471("minecraft-cursor.options.debug.report_issues");
    private static final class_2561 OPEN_WIKI_TEXT = class_2561.method_43471("minecraft-cursor.options.debug.open_wiki");
    private OptionsListWidget optionsList;
    private ButtonWidget cacheButton;
    private int previousCacheSize = CursorTypeResolver.INSTANCE.cacheSize();

    public DebugOptionsPanel(class_2561 title) {
        super(title);
    }

    @Override
    protected void initContents() {
        this.optionsList = new OptionsListWidget(this.getMinecraft(), this.getFont(), this.getSpacing());

        this.optionsList.addToggle(
                CursorTypeResolver.INSTANCE.getInspector().isInspecting(),
                v -> CursorTypeResolver.INSTANCE.toggleInspector(),
                this.index(INSPECT_TEXT),
                null,
                true
        );

        this.previousCacheSize = -1;
        this.cacheButton = new ButtonWidget(createCacheText(), CursorTypeResolver.INSTANCE::clearCache);
        this.optionsList.addWidget(this.cacheButton);
        this.index(CACHE_TEXT);

        this.optionsList.addWidget(new ButtonWidget(
                this.index(OPEN_WIKI_TEXT),
                class_407.method_60867(this.getScreen(), WIKI_LINK, true)
        ));
        this.optionsList.addWidget(new ButtonWidget(
                this.index(REPORT_ISSUES_TEXT),
                class_407.method_60867(this.getScreen(), ISSUES_LINK, true)
        ));

        this.optionsList.search(this.getSearch());

        this.addRenderableWidget(this.optionsList);
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.optionsList != null) {
            this.optionsList.method_55445(this.getWidth(), this.computeMaxHeight(y));
            this.optionsList.method_48229(x, y);
        }
    }

    @Override
    protected void searched(@NotNull String search, @Nullable class_2561 matched) {
        if (this.optionsList != null) {
            this.optionsList.search(search);
        }
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.cacheButton != null && CursorTypeResolver.INSTANCE.cacheSize() != this.previousCacheSize) {
            this.previousCacheSize = CursorTypeResolver.INSTANCE.cacheSize();
            this.cacheButton.method_25355(createCacheText());
        }

        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private static class_2561 createCacheText() {
        return class_2561.method_43469(CLEAR_CACHE_KEY, CursorTypeResolver.INSTANCE.cacheSize());
    }
}
