package io.github.fishstiz.minecraftcursor.gui.widget;

import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonWidget extends class_4185 {
    private static final int DEFAULT_SPRITE_SIZE = 16;
    private static final int DISABLED_SPRITE_COLOR = 0x80A0A0A0; // 50% gray
    private @Nullable class_2960 sprite;
    private int textureWidth;
    private int textureHeight;

    public ButtonWidget(int x, int y, int width, int height, class_2561 message, Runnable onPress) {
        super(x, y, width, height, message, btn -> onPress.run(), class_4185.field_40754);
    }

    public ButtonWidget(int x, int y, int width, int height, class_2561 message, class_4241 onPress) {
        super(x, y, width, height, message, onPress, class_4185.field_40754);
    }

    public ButtonWidget(class_2561 message, Runnable onPress) {
        this(0, 0, field_39500, field_39501, message, onPress);
    }

    public ButtonWidget(class_2561 message, class_4241 onPress) {
        this(0, 0, field_39500, field_39501, message, onPress);
    }

    public ButtonWidget withSize(int size) {
        this.method_55445(size, size);
        return this;
    }

    public ButtonWidget withTooltip(@Nullable class_7919 tooltip) {
        this.method_47400(tooltip);
        return this;
    }

    public ButtonWidget withTooltip(@NotNull class_2561 message) {
        this.method_47400(class_7919.method_47407(message));
        return this;
    }

    public ButtonWidget spriteOnly(@NotNull class_2960 sprite, int textureWidth, int textureHeight) {
        this.sprite = sprite;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        return this;
    }

    public ButtonWidget spriteOnly(@NotNull class_2960 sprite) {
        return this.spriteOnly(sprite, DEFAULT_SPRITE_SIZE, DEFAULT_SPRITE_SIZE);
    }

    @Override
    public void method_25357(double mouseX, double mouseY) {
        this.method_25365(false);
    }

    @Override
    protected void method_49604(@NotNull class_332 guiGraphics, @NotNull class_327 font, int width, int color) {
        if (this.sprite == null) {
            super.method_49604(guiGraphics, font, width, color);
        }
    }

    @Override
    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);

        if (this.sprite != null) {
            int spriteWidth = Math.min(this.method_25368(), this.textureWidth);
            int spriteHeight = Math.min(this.method_25364(), this.textureHeight);
            int spriteX = this.method_46426() + (this.method_25368() - spriteWidth) / 2;
            int spriteY = this.method_46427() + (this.method_25364() - spriteHeight) / 2;
            int color = this.field_22763 ? -1 : DISABLED_SPRITE_COLOR;

            guiGraphics.method_25293(
                    class_1921::method_62277,
                    this.sprite,
                    spriteX, spriteY,
                    0,0,
                    this.textureWidth, this.textureHeight,
                    spriteWidth, spriteHeight,
                    this.textureWidth, this.textureHeight,
                    color
            );
        }
    }
}
