package io.github.fishstiz.minecraftcursor.gui.widget;

import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class InactiveInfoWidget extends ButtonWidget {
    private static final class_2960 ICON = class_2960.method_60656("textures/gui/sprites/icon/unseen_notification.png");
    private static final int SIZE = 16;
    private static final int ICON_SIZE = 10;
    private static final int MARGIN_RIGHT = 2;
    private final class_339 widget;

    public InactiveInfoWidget(class_339 widget, class_7919 tooltip, Runnable onPress) {
        super(class_5244.field_39003, onPress);

        this.widget = widget;
        this.field_22763 = false;
        this.method_55445(SIZE, SIZE);
        this.method_47400(tooltip);
        this.refreshPosition();
        this.refreshVisibility();
    }

    private void refreshVisibility() {
        this.field_22763 = !this.widget.field_22763 && this.widget.field_22764;
    }

    private void refreshPosition() {
        int x = (this.widget.method_46426() + this.widget.method_25368()) - this.method_25368() - MARGIN_RIGHT;
        int y = this.widget.method_46427() + (this.widget.method_25364() - this.method_25364()) / 2;
        this.method_48229(x, y);
    }

    @Override
    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.refreshPosition();
        this.refreshVisibility();

        if (this.field_22763) {
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416(0, 0, 1);

            super.method_48579(guiGraphics, mouseX, mouseY, partialTick);

            int iconX = this.method_46426() + (this.method_25368() - ICON_SIZE) / 2;
            int iconY = this.method_46427() + (this.method_25364() - ICON_SIZE) / 2;
            guiGraphics.method_25290(
                    class_1921::method_62277,
                    ICON,
                    iconX, iconY,
                    0, 0,
                    ICON_SIZE, ICON_SIZE,
                    ICON_SIZE, ICON_SIZE
            );

            poseStack.method_22909();
        } else {
            this.field_22762 = false;
        }
    }
}
