package io.github.fishstiz.minecraftcursor.mixin.cursorhandler;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_481;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_481.class)
public abstract class CreativeModeInventoryScreenMixin extends AbstractContainerScreenMixin<class_481.class_483> {
    @Shadow
    private boolean scrolling;

    @Shadow
    @Nullable
    private class_1735 destroyItemSlot;

    @Shadow
    private static class_1761 selectedTab;

    protected CreativeModeInventoryScreenMixin(class_2561 title) {
        super(title);
    }

    @Override
    public @NotNull CursorType minecraft_cursor$getCursorType(double mouseX, double mouseY) {
        if (CursorTypeUtil.canShift()
            && this.hoveredSlot != null
            && this.hoveredSlot == this.destroyItemSlot) {
            return CursorType.SHIFT;
        }
        return super.minecraft_cursor$getCursorType(mouseX, mouseY);
    }

    @Inject(method = "renderBg", at = @At("RETURN"))
    private void forceDefaultOnScroll(class_332 guiGraphics, float partialTick, int mouseX, int mouseY, CallbackInfo ci) {
        if (selectedTab.method_7756() && this.scrolling && CursorTypeUtil.isLeftClickHeld()) {
            CursorController.getInstance().setSingleCycleCursor(CursorType.DEFAULT_FORCE);
        }
    }

    @Inject(method = "checkTabHovering", at = @At("RETURN"))
    private void setPointerOnHover(class_332 guiGraphics, class_1761 creativeModeTab, int mouseX, int mouseY, CallbackInfoReturnable<Boolean> cir) {
        if (MinecraftCursor.CONFIG.isCreativeTabsEnabled()
            && creativeModeTab != selectedTab
            && cir.getReturnValue()
            && this.minecraft_cursor$getCursorType(mouseX, mouseY).isDefault()) {
            CursorController.getInstance().setSingleCycleCursor(CursorType.POINTER);
        }
    }
}
