package io.github.fishstiz.minecraftcursor.util;

import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class CursorTypeUtil {
    private CursorTypeUtil() {
    }

    public static final long WINDOW = class_310.method_1551().method_22683().method_4490();

    public static boolean canShift() {
        return CursorManager.INSTANCE.isEnabled(CursorType.SHIFT) &&
               (class_3675.method_15987(WINDOW, GLFW.GLFW_KEY_LEFT_SHIFT) ||
                class_3675.method_15987(WINDOW, GLFW.GLFW_KEY_RIGHT_SHIFT));
    }

    public static boolean isGrabbing() {
        return CursorManager.INSTANCE.isEnabled(CursorType.GRABBING) &&
               CursorManager.INSTANCE.getAppliedCursor().getType().isKey(CursorType.GRABBING) &&
               isLeftClickHeld();
    }

    public static boolean isLeftClickHeld() {
        return GLFW.glfwGetMouseButton(WINDOW, GLFW.GLFW_MOUSE_BUTTON_1) == GLFW.GLFW_PRESS;
    }

    public static @Nullable CursorType mapGLFWCursor(int shape) {
        return switch (shape) {
            case GLFW.GLFW_ARROW_CURSOR -> CursorType.DEFAULT;
            case GLFW.GLFW_POINTING_HAND_CURSOR -> CursorType.POINTER;
            case GLFW.GLFW_IBEAM_CURSOR -> CursorType.TEXT;
            case GLFW.GLFW_CROSSHAIR_CURSOR -> CursorType.CROSSHAIR;
            case GLFW.GLFW_RESIZE_EW_CURSOR -> CursorType.RESIZE_EW;
            case GLFW.GLFW_RESIZE_NS_CURSOR -> CursorType.RESIZE_NS;
            case GLFW.GLFW_RESIZE_NWSE_CURSOR -> CursorType.RESIZE_NWSE;
            case GLFW.GLFW_RESIZE_NESW_CURSOR -> CursorType.RESIZE_NESW;
            case GLFW.GLFW_RESIZE_ALL_CURSOR -> CursorType.GRABBING;
            case GLFW.GLFW_NOT_ALLOWED_CURSOR -> CursorType.NOT_ALLOWED;
            default -> null;
        };
    }
}
