/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationMode;
import java.util.Random;
import net.minecraft.class_156;

public class AnimationState {
    private static final long MS_PER_TICK = 50L;
    private static final Random RANDOM = new Random();
    private long lastFrameTime = 0L;
    private int currentFrame = 0;
    private boolean oscillateReversed = false;
    private int[] shuffledFrames;
    private int shuffledIndex = 0;

    private boolean isNext(AnimatedCursor cursor, long currentTime) {
        return currentTime - this.lastFrameTime >= (long)cursor.getFrame(this.currentFrame).time() * 50L;
    }

    public int next(AnimatedCursor cursor) {
        long currentTime = class_156.method_658();
        if (!this.isNext(cursor, currentTime)) {
            return this.currentFrame;
        }
        this.lastFrameTime = currentTime;
        this.currentFrame = switch (cursor.getMode()) {
            default -> throw new MatchException(null, null);
            case AnimationMode.LOOP, AnimationMode.LOOP_REVERSE -> (this.currentFrame + 1) % cursor.getFrameCount();
            case AnimationMode.FORWARDS, AnimationMode.REVERSE -> Math.min(this.currentFrame + 1, cursor.getFrameCount() - 1);
            case AnimationMode.OSCILLATE -> {
                boolean v1 = this.oscillateReversed = this.currentFrame != 0 && (this.currentFrame == cursor.getFrameCount() - 1 || this.oscillateReversed);
                if (this.oscillateReversed) {
                    yield this.currentFrame - 1;
                }
                yield this.currentFrame + 1;
            }
            case AnimationMode.RANDOM -> {
                if (cursor.getFrameCount() > 1) {
                    int newFrame;
                    while ((newFrame = RANDOM.nextInt(cursor.getFrameCount())) == this.currentFrame) {
                    }
                    yield newFrame;
                }
                yield this.currentFrame;
            }
            case AnimationMode.RANDOM_CYCLE -> {
                if (this.shuffledFrames == null || this.shuffledIndex >= this.shuffledFrames.length) {
                    int i;
                    int count = cursor.getFrameCount();
                    this.shuffledFrames = new int[count];
                    for (i = 0; i < count; ++i) {
                        this.shuffledFrames[i] = i;
                    }
                    for (i = count - 1; i > 0; --i) {
                        int j = RANDOM.nextInt(i + 1);
                        int tmp = this.shuffledFrames[i];
                        this.shuffledFrames[i] = this.shuffledFrames[j];
                        this.shuffledFrames[j] = tmp;
                    }
                    this.shuffledIndex = 0;
                }
                yield this.shuffledFrames[this.shuffledIndex++];
            }
        };
        return this.currentFrame;
    }

    public void reset() {
        this.lastFrameTime = class_156.method_658();
        this.currentFrame = 0;
        this.oscillateReversed = false;
        this.shuffledFrames = null;
        this.shuffledIndex = 0;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }
}

