/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.util;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.mixin.NativeImageAccess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import net.minecraft.class_1011;
import org.lwjgl.system.MemoryUtil;

public class NativeImageUtil {
    private NativeImageUtil() {
    }

    public static class_1011 cropImage(class_1011 src, int xOffset, int yOffset, int width, int height) {
        int srcWidth = src.method_4307();
        int srcHeight = src.method_4323();
        if (xOffset < 0 || yOffset < 0 || xOffset + width > srcWidth || yOffset + height > srcHeight) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Image size {}x{} is invalid. Valid size: {}x{} at y {}", new Object[]{srcWidth, srcHeight, width, height, yOffset});
            return src;
        }
        class_1011 out = new class_1011(width, height, true);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int color = src.method_61940(x + xOffset, y + yOffset);
                out.method_61941(x, y, color);
            }
        }
        return out;
    }

    public static class_1011 scaleImage(class_1011 src, double scale) {
        int width = (int)Math.round((double)src.method_4307() * scale);
        int height = (int)Math.round((double)src.method_4323() * scale);
        class_1011 scaled = new class_1011(width, height, true);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int srcX = (int)((double)x / scale);
                int srcY = (int)((double)y / scale);
                scaled.method_61941(x, y, src.method_61940(srcX, srcY));
            }
        }
        return scaled;
    }

    public static void writePixelsRGBA(class_1011 image, ByteBuffer buffer) {
        int[] pixelsABGR;
        for (int abgr : pixelsABGR = image.method_48463()) {
            int a = abgr >> 24 & 0xFF;
            int b = abgr >> 16 & 0xFF;
            int g = abgr >> 8 & 0xFF;
            int r = abgr & 0xFF;
            buffer.put((byte)r);
            buffer.put((byte)g);
            buffer.put((byte)b);
            buffer.put((byte)a);
        }
        buffer.flip();
    }

    public static class_1011 readLarge(byte[] bytes) throws IOException {
        ByteBuffer buffer = null;
        try {
            buffer = MemoryUtil.memAlloc((int)bytes.length);
            buffer.put(bytes);
            buffer.rewind();
            class_1011 class_10112 = class_1011.method_4324((ByteBuffer)buffer);
            return class_10112;
        }
        finally {
            if (buffer != null) {
                MemoryUtil.memFree((Buffer)buffer);
            }
        }
    }

    public static byte[] getBytes(class_1011 image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(baos);
        boolean success = ((NativeImageAccess)image).invokeWriteToChannel(channel);
        channel.close();
        if (!success) {
            throw new IOException("Failed to write NativeImage to PNG bytes.");
        }
        return baos.toByteArray();
    }
}

