package io.github.fishstiz.minecraftcursor;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_3264;

public class MinecraftCursorFabric implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        MinecraftCursor.init();

        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new CursorResourceReloadListener());

        ScreenEvents.BEFORE_INIT.register((client, screen, width, height) -> {
            MinecraftCursor.getInstance().beforeScreenInit(screen);

            if (client.field_1755 != null) {
                ScreenEvents.afterRender(client.field_1755).register((currentScreen, context, mouseX, mouseY, delta) ->
                        MinecraftCursor.getInstance().afterRenderScreen(mouseX, mouseY));
            }
        });

        ClientTickEvents.START_CLIENT_TICK.register(client -> MinecraftCursor.getInstance().tick());
    }
}
