/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.compat;

import com.mojang.blaze3d.platform.cursor.CursorType;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.TexturedCursorType;

public final class ModCursor {
    private final long handle;
    private final String source;
    private final String name;
    private final boolean custom;
    private CursorType cursorType;

    private ModCursor(long handle, String source, String name, boolean custom) {
        this.handle = handle;
        this.source = source;
        this.name = name;
        this.custom = custom;
    }

    public ModCursor(long handle, String source, String name) {
        this(handle, source, name, false);
    }

    public ModCursor(long handle, String source, CursorType cursorType) {
        this(handle, source, cursorType.toString());
        this.cursorType = cursorType;
    }

    public static ModCursor createCustom(long handle, String source) {
        return new ModCursor(handle, source, ModCursor.createCustomName(source, handle), true);
    }

    public long handle() {
        return this.handle;
    }

    public String source() {
        return this.source;
    }

    public boolean custom() {
        return this.custom;
    }

    public CursorType cursorType() {
        if (this.cursorType == null) {
            if (this.custom) {
                this.cursorType = new CursorType(this.name, this.handle);
                ((TexturedCursorType)this.cursorType).cursors_extended$setCustom(true);
            } else {
                Cursor cursor = CursorsExtended.getInstance().getRegistry().tryGet(this.name);
                this.cursorType = cursor == null ? new CursorType(this.name, this.handle) : cursor.cursorType();
            }
        }
        return this.cursorType;
    }

    private static String createCustomName(String source, long handle) {
        return "cursors_extended/custom_cursor/" + source + "/" + handle;
    }
}

