/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.config;

import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.cursor.AnimationMode;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public record CursorMetadata(CursorSettings cursor, @Nullable Animation animation) implements Serializable
{
    public static final String FILE_TYPE = ".json";

    public CursorMetadata(CursorSettings cursor, @Nullable Animation animation) {
        this.cursor = cursor = cursor != null ? cursor : new CursorSettings();
        this.animation = animation;
    }

    public CursorMetadata() {
        this(new CursorSettings(), null);
    }

    public Animation requireAnimation() {
        return Objects.requireNonNull(this.animation, "Metadata animation must not be null");
    }

    public record CursorSettings(boolean enabled, float scale, int xhot, int yhot, @Nullable Boolean animated) implements CursorProperties
    {
        public CursorSettings() {
            this(true, 1.0f, 0, 0, SettingsUtil.ANIMATED);
        }
    }

    public record Animation(AnimationMode mode, int frametime, List<Frame> frames, @Nullable Integer width, @Nullable Integer height) {
        private final List<Frame> frames;
        private static final int MIN_TIME = 1;

        public Animation(AnimationMode mode, int frametime, List<Frame> frames, @Nullable Integer width, @Nullable Integer height) {
            mode = mode != null ? mode : AnimationMode.LOOP;
            frametime = Math.max(frametime, 1);
            frames = frames != null ? frames : Collections.emptyList();
        }

        public List<Frame> frames() {
            return List.copyOf(this.frames);
        }

        public record Frame(int index, int time) {
            public int clampedTime(Animation animation) {
                return this.time > 0 ? this.time : Math.max(animation.frametime, 1);
            }
        }
    }
}

