/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor;

import com.mojang.blaze3d.platform.cursor.CursorType;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.TexturedCursorType;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import net.minecraft.network.chat.Component;
import org.jspecify.annotations.Nullable;

public final class Cursor {
    private final CursorType cursorType;
    private boolean lazy = true;

    public Cursor(CursorType cursorType) {
        this.cursorType = cursorType;
    }

    public long handle() {
        CursorTexture texture;
        if (!this.isCustom() && CursorsExtended.CONFIG.getOrCreateSettings(this).enabled() && (texture = this.getTexture()) != null && texture.handle() != 0L) {
            return texture.handle();
        }
        return this.cursorType.handle;
    }

    public String name() {
        return this.cursorType.toString();
    }

    public @Nullable CursorTexture getTexture() {
        return this.texturedCursorType().cursors_extended$getTexture();
    }

    public void setTexture(CursorTexture texture) {
        this.texturedCursorType().cursors_extended$setTexture(texture);
    }

    public boolean hasTexture() {
        return this.getTexture() != null;
    }

    public boolean isTextureEnabled() {
        return this.hasTexture() && CursorsExtended.CONFIG.getOrCreateSettings(this).enabled();
    }

    public CursorType cursorType() {
        return this.cursorType;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public boolean isCustom() {
        return this.texturedCursorType().cursors_extended$isCustom();
    }

    public Component text() {
        return Component.translatable((String)("cursors_extended.options.cursor-type." + this.name()));
    }

    private TexturedCursorType texturedCursorType() {
        return (TexturedCursorType)this.cursorType;
    }
}

