/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.cursor.CursorType;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorProvider;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.cursor.CursorRenderer;
import io.github.fishstiz.cursors_extended.cursor.debug.CursorDebugRenderer;
import io.github.fishstiz.cursors_extended.lifecycle.ClientStartedListener;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import org.jspecify.annotations.Nullable;

public class CursorDisplay
implements ClientStartedListener {
    private final CursorRegistry registry;
    private Minecraft minecraft;
    private CursorDebugRenderer debugRenderer = CursorDebugRenderer.NOP;
    private CursorRenderer cursorRenderer;
    private @Nullable Screen visibleScreen;

    public CursorDisplay(CursorRegistry registry) {
        this.registry = registry;
        this.cursorRenderer = new CursorRenderer.Native(registry);
    }

    @Override
    public void onClientStarted(Minecraft minecraft) {
        this.minecraft = minecraft;
        if (CursorsExtended.CONFIG.isVirtualMode() != this.isVirtual()) {
            this.toggleVirtual();
        }
    }

    public CursorType getCursorAt(Window window) {
        Screen screen = this.getVisibleScreen();
        if (screen != null) {
            double mouseX = this.minecraft.mouseHandler.getScaledXPos(window);
            double mouseY = this.minecraft.mouseHandler.getScaledYPos(window);
            return this.getCursorAt((GuiEventListener)screen, mouseX, mouseY);
        }
        return CursorType.DEFAULT;
    }

    public CursorType getCursorAt(GuiEventListener element, double mouseX, double mouseY) {
        if (CursorTypeUtil.isHovered(element, mouseX, mouseY)) {
            if (element instanceof ContainerEventHandler) {
                ContainerEventHandler container = (ContainerEventHandler)element;
                for (GuiEventListener child : container.children()) {
                    CursorType cursorType = this.getCursorAt(child, mouseX, mouseY);
                    if (!CursorTypeUtil.nonDefault(cursorType)) continue;
                    return cursorType;
                }
            }
            if (element instanceof CursorProvider) {
                CursorProvider provider = (CursorProvider)element;
                this.debugRenderer.setLastCursorAt(element, mouseX, mouseY);
                return provider.cursors_extended$cursorType(mouseX, mouseY);
            }
            this.debugRenderer.setLastCursorAt(element, mouseX, mouseY);
        }
        return CursorType.DEFAULT;
    }

    public void setVisibleScreen(@Nullable Screen visibleScreen) {
        this.visibleScreen = visibleScreen;
    }

    public @Nullable Screen getVisibleScreen() {
        Screen screen = this.minecraft.screen;
        return screen != null ? screen : this.visibleScreen;
    }

    public void toggleVirtual() {
        this.cursorRenderer.resetCursor(this.minecraft.getWindow());
        this.cursorRenderer = this.isVirtual() ? new CursorRenderer.Native(this.registry) : new CursorRenderer.Virtual(this.registry);
        this.cursorRenderer.applyCursor(this.minecraft.getWindow());
    }

    public void renderCursor(Window window, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.cursorRenderer.render(window, this.minecraft, guiGraphics, mouseX, mouseY);
    }

    public boolean isVirtual() {
        return this.cursorRenderer instanceof CursorRenderer.Virtual;
    }

    public void toggleDebugger() {
        this.debugRenderer = this.debugRenderer.isActive() ? CursorDebugRenderer.NOP : CursorDebugRenderer.create();
    }

    public void renderDebugger(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.debugRenderer.render(this.minecraft, this::getVisibleScreen, guiGraphics, mouseX, mouseY);
    }

    public boolean isDebugging() {
        return this.debugRenderer.isActive();
    }

    public void applyCursor(Window window) {
        this.cursorRenderer.applyCursor(window);
    }

    public Cursor getDisplayedCursor(Window window) {
        return this.cursorRenderer.getCurrentCursor(window);
    }

    public Cursor getDisplayedCursor() {
        return this.getDisplayedCursor(this.minecraft.getWindow());
    }

    public Window getWindow() {
        return this.minecraft.getWindow();
    }
}

