/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor;

import com.mojang.blaze3d.platform.cursor.CursorType;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.cursor.TexturedCursorType;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class CursorRegistry {
    private final Map<String, Cursor> registry = new Object2ObjectLinkedOpenHashMap();
    private volatile Map<String, Cursor> external;
    private Map<String, Cursor> custom;

    public void onInitRenderSystem() {
        this.register(CursorType.DEFAULT);
        this.registerAlias(CursorType.DEFAULT, CursorTypes.ARROW);
        this.register(CursorTypes.POINTING_HAND);
        this.register(CursorTypesExt.GRABBING);
        this.register(CursorTypes.IBEAM);
        this.register(CursorTypesExt.SHIFT);
        this.register(CursorTypesExt.BUSY);
        this.register(CursorTypes.NOT_ALLOWED);
        this.register(CursorTypes.CROSSHAIR);
        this.register(CursorTypes.RESIZE_ALL);
        this.register(CursorTypes.RESIZE_EW);
        this.register(CursorTypes.RESIZE_NS);
        this.register(CursorTypesExt.RESIZE_NWSE);
        this.register(CursorTypesExt.RESIZE_NESW);
    }

    public void register(CursorType cursorType) {
        this.registry.putIfAbsent(cursorType.toString(), new Cursor(cursorType));
    }

    public void registerAlias(CursorType cursorType, CursorType alias) {
        this.registry.putIfAbsent(alias.toString(), this.get(cursorType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor get(CursorType cursorType) {
        Cursor cursor = this.registry.get(cursorType.toString());
        if (cursor != null) {
            return cursor;
        }
        CursorRegistry cursorRegistry = this;
        synchronized (cursorRegistry) {
            Object2ObjectOpenHashMap map = ((TexturedCursorType)cursorType).cursors_extended$isCustom() ? (this.custom == null ? (this.custom = new Object2ObjectOpenHashMap()) : this.custom) : (this.external == null ? (this.external = new Object2ObjectOpenHashMap()) : this.external);
            return map.computeIfAbsent(cursorType.toString(), name -> {
                CursorsExtended.LOGGER.info("[cursors_extended] Found external cursor type: {}", (Object)cursorType);
                return new Cursor(cursorType);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCustom(CursorType cursorType) {
        CursorRegistry cursorRegistry = this;
        synchronized (cursorRegistry) {
            if (this.custom != null) {
                this.custom.remove(cursorType.toString());
            }
        }
    }

    public @Nullable Cursor tryGet(String cursorType) {
        Cursor cursor = this.registry.get(cursorType);
        return cursor != null || this.external == null ? cursor : this.external.get(cursorType);
    }

    public Set<Cursor> getCursors() {
        ObjectOpenHashSet cursors = new ObjectOpenHashSet();
        cursors.addAll(this.registry.values());
        if (this.external != null) {
            cursors.addAll(this.external.values());
        }
        return cursors;
    }

    public Set<Cursor> getInternalCursors() {
        return new ObjectLinkedOpenHashSet(this.registry.values());
    }
}

