/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.cursor.CursorType;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import org.lwjgl.glfw.GLFW;

public sealed interface CursorRenderer {
    public CursorRegistry registry();

    public void applyCursor(Window var1);

    public void resetCursor(Window var1);

    public void render(Window var1, Minecraft var2, GuiGraphics var3, int var4, int var5);

    default public Cursor getCurrentCursor(Window window) {
        return this.registry().get(window.currentCursor);
    }

    public static final class Virtual
    implements CursorRenderer {
        private final CursorRegistry registry;
        private Identifier textureLocation;
        private int textureWidth;
        private int textureHeight;
        private int spriteWidth;
        private int spriteHeight;
        private float drawWidth;
        private float drawHeight;
        private int vOffset;
        private float xhot;
        private float yhot;

        public Virtual(CursorRegistry registry) {
            this.registry = registry;
        }

        @Override
        public CursorRegistry registry() {
            return this.registry;
        }

        @Override
        public void applyCursor(Window window) {
            Cursor cursor = this.getCurrentCursor(window);
            cursor.cursorType().select(window);
            CursorTexture texture = cursor.getTexture();
            if (texture == null || cursor.isCustom() || !CursorsExtended.CONFIG.getOrCreateSettings(cursor).enabled()) {
                this.textureLocation = null;
                return;
            }
            this.textureLocation = texture.texturePath();
            this.textureWidth = texture.textureWidth();
            this.textureHeight = texture.textureHeight();
            this.spriteWidth = texture.spriteWidth();
            this.spriteHeight = texture.spriteHeight();
            this.vOffset = texture.spriteVOffset();
            float scale = SettingsUtil.getAutoScale(texture.scale());
            this.xhot = (float)texture.xhot() * scale;
            this.yhot = (float)texture.yhot() * scale;
            this.drawWidth = (float)this.spriteWidth * scale;
            this.drawHeight = (float)this.spriteHeight * scale;
        }

        @Override
        public void resetCursor(Window window) {
            GLFW.glfwSetInputMode((long)window.handle(), (int)208897, (int)212993);
            this.textureLocation = null;
        }

        @Override
        public void render(Window window, Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (!minecraft.mouseHandler.isMouseGrabbed()) {
                if (this.textureLocation != null) {
                    int guiScale = minecraft.getWindow().getGuiScale();
                    int scaledWidth = Math.round(this.drawWidth / (float)guiScale);
                    int scaledHeight = Math.round(this.drawHeight / (float)guiScale);
                    int x = mouseX - Math.round(this.xhot / (float)guiScale);
                    int y = mouseY - Math.round(this.yhot / (float)guiScale);
                    GLFW.glfwSetInputMode((long)window.handle(), (int)208897, (int)212994);
                    guiGraphics.nextStratum();
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.textureLocation, x, y, 0.0f, (float)this.vOffset, scaledWidth, scaledHeight, this.spriteWidth, this.spriteHeight, this.textureWidth, this.textureHeight);
                } else {
                    GLFW.glfwSetInputMode((long)window.handle(), (int)208897, (int)212993);
                }
            }
        }
    }

    public record Native(CursorRegistry registry) implements CursorRenderer
    {
        @Override
        public void applyCursor(Window window) {
            this.getCurrentCursor(window).cursorType().select(window);
        }

        @Override
        public void resetCursor(Window window) {
            window.selectCursor(CursorType.DEFAULT);
        }

        @Override
        public void render(Window window, Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        }
    }
}

