/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.screen.panel;

import com.mojang.blaze3d.platform.cursor.CursorType;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.gui.screen.panel.AbstractOptionsPanel;
import io.github.fishstiz.cursors_extended.gui.widget.OptionsListWidget;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AdaptiveOptionsPanel
extends AbstractOptionsPanel {
    private static final Tooltip ADAPTIVE_INFO = Tooltip.create((Component)Component.translatable((String)"cursors_extended.options.adapt.tooltip"));
    private static final Component HOLD_CURSORS = Component.translatable((String)"cursors_extended.options.adapt.hold");
    private static final Tooltip HOLD_CURSORS_INFO = Tooltip.create((Component)Component.translatable((String)"cursors_extended.options.adapt.hold.tooltip"));
    private static final Component ITEM_SLOT = Component.translatable((String)"cursors_extended.options.adapt.item_slot");
    private static final Component ITEM_GRAB = Component.translatable((String)"cursors_extended.options.adapt.item_grab");
    private static final Component SCROLLBAR_POINTER = AdaptiveOptionsPanel.scrollbarText(CursorTypes.POINTING_HAND);
    private static final Component SCROLLBAR_RESIZE = AdaptiveOptionsPanel.scrollbarText(CursorTypes.RESIZE_NS);
    private static final int CURSOR_SIZE_STEP = 8;
    private final Runnable refreshCursors;
    private OptionsListWidget optionsList;

    public AdaptiveOptionsPanel(Component title, Runnable refreshCursors) {
        super(title);
        this.refreshCursors = refreshCursors;
    }

    @Override
    protected void initContents() {
        this.optionsList = new OptionsListWidget(this.getMinecraft(), this.getFont(), 20, this.getSpacing());
        this.optionsList.addToggle(this.isAdaptiveTexturesEnabled(), this::toggleAdaptive, ENABLE_TEXT, ADAPTIVE_INFO, CursorsExtended.CONFIG.hasResourcePack());
        this.addOption(CursorsExtended.CONFIG.isHeldCursorsEnabled(), CursorsExtended.CONFIG::setHeldCursorsEnabled, HOLD_CURSORS, HOLD_CURSORS_INFO, null);
        this.addOption(CursorsExtended.CONFIG.isItemSlotEnabled(), CursorsExtended.CONFIG::setItemSlotEnabled, ITEM_SLOT, CursorTypes.POINTING_HAND);
        this.addOption(CursorsExtended.CONFIG.isItemGrabbingEnabled(), CursorsExtended.CONFIG::setItemGrabbingEnabled, ITEM_GRAB, CursorTypesExt.GRABBING);
        this.addOption(CursorsExtended.CONFIG.isPointerScrollbarEnabled(), CursorsExtended.CONFIG::setPointerScrollbarEnabled, SCROLLBAR_POINTER, CursorTypes.POINTING_HAND);
        this.addOption(CursorsExtended.CONFIG.isResizeScrollbarEnabled(), CursorsExtended.CONFIG::setResizeScrollbarEnabled, SCROLLBAR_RESIZE, CursorTypes.RESIZE_NS);
        this.optionsList.search(this.getSearch());
        this.addRenderableWidget(this.optionsList);
    }

    private void addOption(boolean value, Consumer<Boolean> consumer, Component label, CursorType cursorType) {
        this.addOption(value, consumer, label, null, cursorType);
    }

    private void addOption(boolean value, Consumer<Boolean> consumer, Component label, Tooltip tooltip, CursorType cursorType) {
        this.optionsList.addToggle(value, consumer, this.index(label), this.prefixCursor(cursorType), tooltip, true);
    }

    private OptionsListWidget.Prefix prefixCursor(CursorType cursorType) {
        if (cursorType == null) {
            return null;
        }
        Cursor cursor = CursorsExtended.getInstance().getRegistry().get(cursorType);
        if (!cursor.hasTexture()) {
            return null;
        }
        return (guiGraphics, font, x, y, height) -> {
            int adjustedHeight = height - height % 8;
            int offsetY = y + (height - adjustedHeight) / 2;
            DrawUtil.drawCursor(guiGraphics, cursor, x, offsetY, adjustedHeight);
            return adjustedHeight;
        };
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.optionsList != null) {
            this.optionsList.setSize(this.getWidth(), this.computeMaxHeight(y));
            this.optionsList.setPosition(x, y);
        }
    }

    @Override
    protected void searched(@NonNull String search, @Nullable Component matched) {
        if (this.optionsList != null) {
            this.optionsList.search(search);
        }
    }

    private void toggleAdaptive(boolean adaptive) {
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getInternalCursors()) {
            if (cursor.cursorType() == CursorType.DEFAULT) continue;
            if (adaptive && cursor.getTexture() == null && CursorsExtended.CONFIG.hasResourcePack()) {
                AdaptiveOptionsPanel.loadCursor(cursor);
            }
            CursorsExtended.CONFIG.getOrCreateSettings(cursor).setEnabled(adaptive);
        }
        this.refreshCursors.run();
        this.refreshWidgets();
        this.repositionElements();
    }

    private boolean isAdaptiveTexturesEnabled() {
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getInternalCursors()) {
            if (!CursorTypeUtil.nonDefault(cursor.cursorType()) || !cursor.isTextureEnabled()) continue;
            return true;
        }
        return false;
    }

    private static Component scrollbarText(CursorType cursorType) {
        return Component.translatable((String)"cursors_extended.options.adapt.scrollbar", (Object[])new Object[]{Component.translatable((String)("cursors_extended.options.cursor-type." + cursorType.toString()))});
    }
}

