/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.screen.panel;

import com.mojang.blaze3d.platform.cursor.CursorType;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.config.Config;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.gui.MouseEvent;
import io.github.fishstiz.cursors_extended.gui.screen.CatalogItem;
import io.github.fishstiz.cursors_extended.gui.screen.panel.AbstractOptionsPanel;
import io.github.fishstiz.cursors_extended.gui.widget.AbstractListWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ButtonWidget;
import io.github.fishstiz.cursors_extended.gui.widget.CursorHotspotWidget;
import io.github.fishstiz.cursors_extended.gui.widget.CursorPreviewWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ElementSlidingBackground;
import io.github.fishstiz.cursors_extended.gui.widget.InactiveInfoWidget;
import io.github.fishstiz.cursors_extended.gui.widget.SliderWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ToggleWidget;
import io.github.fishstiz.cursors_extended.resource.texture.AnimatedCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CursorOptionsPanel
extends AbstractOptionsPanel {
    private static final Component HOTSPOT_GUIDE_TEXT = Component.translatable((String)"cursors_extended.options.hotspot-guide");
    private static final Component ANIMATE_TEXT = Component.translatable((String)"cursors_extended.options.animate");
    private static final Component RESET_ANIMATION_TEXT = Component.translatable((String)"cursors_extended.options.animate-reset");
    private static final Component RESET_DEFAULTS_TEXT = Component.translatable((String)"cursors_extended.options.reset-defaults");
    private static final Tooltip GLOBAL_SCALE_TOOLTIP = CursorOptionsPanel.createGlobalTooltip(SCALE_TEXT);
    private static final Tooltip GLOBAL_XHOT_TOOLTIP = CursorOptionsPanel.createGlobalTooltip(XHOT_TEXT);
    private static final Tooltip GLOBAL_YHOT_TOOLTIP = CursorOptionsPanel.createGlobalTooltip(YHOT_TEXT);
    private static final int CELL_SIZE_STEP = 32;
    private final Runnable refreshCursors;
    private final CatalogItem globalOptions;
    private final Config.CursorSettings settings;
    private final Cursor cursor;
    private GridLayout layout;
    private OptionsList optionsList;
    private SliderWidget scaleSlider;
    private ButtonWidget guiScaleButton;
    private SliderWidget xhotSlider;
    private SliderWidget yhotSlider;
    private ButtonWidget resetToDefaultsButton;
    private CursorHotspotWidget hotspotWidget;
    private CursorPreviewWidget previewWidget;
    private ToggleWidget hotspotGuideToggler;
    private boolean scaling = false;

    public CursorOptionsPanel(Runnable refreshCursors, CatalogItem globalOptions, Cursor cursor) {
        super((Component)Component.translatable((String)"cursors_extended.options.cursor-type", (Object[])new Object[]{cursor.text()}));
        this.refreshCursors = refreshCursors;
        this.globalOptions = globalOptions;
        this.settings = CursorsExtended.CONFIG.getOrCreateSettings(cursor);
        this.cursor = cursor;
    }

    @Override
    protected void initContents() {
        boolean row = false;
        int column = 0;
        this.layout = new GridLayout().spacing(this.getSpacing());
        this.layout.addChild(this.setupFirstColumnWidgets(), 0, column);
        this.layout.addChild(this.setupSecondColumnWidgets(), 0, ++column);
        this.layout.visitWidgets(x$0 -> this.addRenderableWidget(x$0));
    }

    private @NonNull LayoutElement setupFirstColumnWidgets() {
        this.optionsList = new OptionsList(this.getMinecraft(), 20, this.getSpacing());
        this.optionsList.addOption(new ToggleWidget(this.cursor.isTextureEnabled(), ENABLE_TEXT, this::onToggleEnable));
        if (this.cursor.getTexture() != null) {
            this.scaleSlider = this.optionsList.addOption(new SliderWidget(SettingsUtil.sanitizeScale(this.settings.scale()), 0.0, 8.0, 0.05f, this::onChangeScale, SCALE_TEXT, CommonComponents.EMPTY, SettingsUtil::getAutoText, this::onScaleMouseEvent), this.bindGlobalInfo(GLOBAL_SCALE_TOOLTIP, CursorsExtended.CONFIG.getGlobal().isScaleActive()));
            this.guiScaleButton = this.optionsList.addOption(new ButtonWidget(GUI_SCALE_TEXT, this::setGuiScale));
            this.xhotSlider = this.optionsList.addOption(new SliderWidget(SettingsUtil.sanitizeXHot(this.settings.xhot(), this.cursor), 0.0, SettingsUtil.getMaxXHot(this.cursor), 1.0, this::onChangeXHot, XHOT_TEXT, HOTSPOT_SUFFIX), this.bindGlobalInfo(GLOBAL_XHOT_TOOLTIP, CursorsExtended.CONFIG.getGlobal().isXHotActive()));
            this.yhotSlider = this.optionsList.addOption(new SliderWidget(SettingsUtil.sanitizeYHot(this.settings.yhot(), this.cursor), 0.0, SettingsUtil.getMaxYHot(this.cursor), 1.0, this::onChangeYHot, YHOT_TEXT, HOTSPOT_SUFFIX), this.bindGlobalInfo(GLOBAL_YHOT_TOOLTIP, CursorsExtended.CONFIG.getGlobal().isYHotActive()));
            this.hotspotGuideToggler = this.optionsList.addOption(new ToggleWidget(CursorsExtended.CONFIG.isShowHotspotGuide(), HOTSPOT_GUIDE_TEXT, this::onToggleGuide));
            CursorTexture cursorTexture = this.cursor.getTexture();
            if (cursorTexture instanceof AnimatedCursorTexture) {
                AnimatedCursorTexture animatedCursor = (AnimatedCursorTexture)cursorTexture;
                this.optionsList.addOption(new ToggleWidget((boolean)animatedCursor.animated(), ANIMATE_TEXT, this::onToggleAnimate));
                this.optionsList.addOption(new ButtonWidget(RESET_ANIMATION_TEXT, this::restartAnimation));
            }
            this.resetToDefaultsButton = this.optionsList.addOption(new ButtonWidget(RESET_DEFAULTS_TEXT, this::resetToDefaults));
            this.refreshGuiScaleButton(this.settings.scale());
            this.refreshDefaultsButton();
        }
        return this.optionsList;
    }

    private @NonNull LayoutElement setupSecondColumnWidgets() {
        boolean column = false;
        int row = 0;
        GridLayout cursorWidgetsLayout = new GridLayout().spacing(this.getSpacing());
        if (this.cursor.getTexture() != null) {
            this.hotspotWidget = (CursorHotspotWidget)cursorWidgetsLayout.addChild((LayoutElement)new CursorHotspotWidget(this.cursor, Objects.requireNonNull(this.xhotSlider), Objects.requireNonNull(this.yhotSlider), this::onHotspotWidgetMouseEvent), row, 0);
            this.hotspotWidget.setRenderRuler(CursorsExtended.CONFIG.isShowHotspotGuide());
            this.previewWidget = (CursorPreviewWidget)cursorWidgetsLayout.addChild((LayoutElement)new CursorPreviewWidget(this.cursor, this.getFont()), ++row, 0);
            this.previewWidget.setRenderRuler(CursorsExtended.CONFIG.isShowHotspotGuide());
        }
        return cursorWidgetsLayout;
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.layout != null) {
            int cellSize = CursorOptionsPanel.clampCell(this.getWidth() / 2 - this.getSpacing() / 2);
            this.layout.visitWidgets(widget -> widget.setWidth(cellSize));
            if (this.optionsList != null) {
                this.optionsList.setHeight(this.computeMaxHeight(y));
            }
            if (this.hotspotWidget != null) {
                this.hotspotWidget.setHeight(cellSize);
            }
            this.layout.setPosition(x, y);
            this.layout.arrangeElements();
            if (this.previewWidget != null) {
                this.previewWidget.setHeight(Math.min(cellSize, this.getBottom() - this.previewWidget.getY()));
            }
        }
    }

    private <T extends AbstractWidget> Function<T, AbstractWidget> bindGlobalInfo(Tooltip tooltip, boolean global) {
        return widget -> {
            if (widget != null && global) {
                widget.active = false;
                return new InactiveInfoWidget((AbstractWidget)widget, tooltip, this::toGlobalOptionsPanel);
            }
            return null;
        };
    }

    private void toGlobalOptionsPanel() {
        this.changeItem(this.globalOptions);
    }

    private void onToggleEnable(ToggleWidget target, boolean enabled) {
        if (!this.cursor.hasTexture() && CursorOptionsPanel.loadCursor(this.cursor)) {
            this.settings.setEnabled(true);
            this.refreshCursors.run();
            return;
        }
        if (this.cursor.hasTexture()) {
            this.settings.setEnabled(enabled);
            this.refreshCursors.run();
        } else {
            target.setValue(false);
        }
    }

    private void onChangeScale(double scale) {
        CursorOptionsPanel.setScale(this.cursor, (float)scale);
        this.settings.setScale((float)scale);
        this.refreshGuiScaleButton(scale);
        this.refreshDefaultsButton();
    }

    private void onChangeXHot(double xhot) {
        CursorOptionsPanel.setXHot(this.cursor, (int)xhot);
        this.settings.setXHot(this.cursor, (int)xhot);
        this.refreshDefaultsButton();
    }

    private void onChangeYHot(double yhot) {
        CursorOptionsPanel.setYHot(this.cursor, (int)yhot);
        this.settings.setYHot(this.cursor, (int)yhot);
        this.refreshDefaultsButton();
    }

    private void onToggleAnimate(boolean animated) {
        CursorTexture cursorTexture = this.cursor.getTexture();
        if (!(cursorTexture instanceof AnimatedCursorTexture)) {
            throw new IllegalStateException("Cursor is not an animated cursor");
        }
        AnimatedCursorTexture animatedCursor = (AnimatedCursorTexture)cursorTexture;
        animatedCursor.setAnimated(animated);
        this.settings.setAnimated(animated);
        this.refreshDefaultsButton();
    }

    private void onToggleGuide(boolean shown) {
        CursorsExtended.CONFIG.setShowHotspotGuide(shown);
        this.hotspotWidget.setRenderRuler(shown);
        this.previewWidget.setRenderRuler(shown);
    }

    private void restartAnimation() {
        CursorTexture cursorTexture = this.cursor.getTexture();
        if (cursorTexture instanceof AnimatedCursorTexture) {
            AnimatedCursorTexture animatedCursor = (AnimatedCursorTexture)cursorTexture;
            animatedCursor.restartAnimation();
        }
    }

    private void setGuiScale(Button target) {
        target.setFocused(false);
        target.active = false;
        if (this.scaleSlider != null) {
            this.scaleSlider.applyMappedValue(0.0);
            this.setFocused((GuiEventListener)this.scaleSlider);
        }
    }

    private void refreshGuiScaleButton(double scale) {
        if (this.guiScaleButton != null) {
            this.guiScaleButton.active = !SettingsUtil.isAutoScale(scale) && !CursorsExtended.CONFIG.getGlobal().isScaleActive();
        }
    }

    private void refreshDefaultsButton() {
        if (this.resetToDefaultsButton != null && this.cursor.getTexture() != null) {
            this.resetToDefaultsButton.active = !SettingsUtil.equalSettings(this.cursor.getTexture().metadata().cursor(), this.settings, true);
        }
    }

    private void resetToDefaults() {
        CursorTexture texture = this.cursor.getTexture();
        if (texture == null) {
            return;
        }
        Config.CursorSettings defaults = this.getDefaults();
        this.settings.mergeAll(defaults);
        CursorsExtended.getInstance().getLoader().updateTexture(this.cursor, CursorsExtended.CONFIG.getGlobal().apply(defaults));
        this.refreshCursors.run();
    }

    private Config.CursorSettings getDefaults() {
        Config.CursorSettings defaultSettings = new Config.CursorSettings();
        if (this.cursor.getTexture() != null) {
            defaultSettings.mergeAll(this.cursor.getTexture().metadata().cursor());
        }
        if (CursorsExtended.CONFIG.getGlobal().isScaleActive()) {
            defaultSettings.setScale(this.settings.scale());
        }
        if (CursorsExtended.CONFIG.getGlobal().isXHotActive()) {
            defaultSettings.setXHot(this.cursor, this.settings.xhot());
        }
        if (CursorsExtended.CONFIG.getGlobal().isYHotActive()) {
            defaultSettings.setYHot(this.cursor, this.settings.yhot());
        }
        return defaultSettings;
    }

    private void onScaleMouseEvent(SliderWidget target, MouseEvent mouseEvent, double mappedValue) {
        this.scaling = (mouseEvent.clicked() || mouseEvent.dragged()) && this.cursor.isTextureEnabled();
    }

    private void onHotspotWidgetMouseEvent(CursorHotspotWidget target, MouseEvent mouseEvent, int xhot, int yhot) {
        if (mouseEvent.clicked() || mouseEvent.dragged()) {
            target.setRenderRuler(true);
            CursorsExtended.CONFIG.setShowHotspotGuide(true);
            if (this.hotspotGuideToggler != null) {
                this.hotspotGuideToggler.setValue(true);
            }
        }
    }

    private static int clampCell(int cell) {
        return Math.round((float)cell / 32.0f) * 32;
    }

    private static Tooltip createGlobalTooltip(Component option) {
        return Tooltip.create((Component)Component.translatable((String)"cursors_extended.options.global.inactive.tooltip", (Object[])new Object[]{option}));
    }

    @Override
    public void render(@NonNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        CursorType cursorType;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.scaling) {
            guiGraphics.requestCursor(CursorTypeUtil.arrowIfDefault(this.cursor.cursorType()));
        } else if (this.hotspotWidget != null && (cursorType = this.hotspotWidget.cursors_extended$cursorType(mouseX, mouseY)) != CursorType.DEFAULT) {
            guiGraphics.requestCursor(cursorType);
        }
    }

    private static class OptionsList
    extends AbstractListWidget<Entry>
    implements Layout {
        private static final int BACKGROUND_PADDING_Y = 2;
        private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF);

        private OptionsList(Minecraft minecraft, int itemHeight, int spacing) {
            super(minecraft, 0, 0, 0, itemHeight, spacing);
        }

        private <T extends AbstractWidget> @NonNull T addOption(@NonNull T optionWidget, @Nullable Function<T, AbstractWidget> decoration) {
            this.addEntry((AbstractSelectionList.Entry)new Entry(this, optionWidget, decoration != null ? decoration.apply(optionWidget) : null));
            return optionWidget;
        }

        private <T extends AbstractWidget> @NonNull T addOption(@NonNull T optionWidget) {
            return this.addOption(optionWidget, null);
        }

        protected void renderListBackground(@NonNull GuiGraphics guiGraphics) {
        }

        protected void renderListSeparators(@NonNull GuiGraphics guiGraphics) {
        }

        public void visitChildren(@NonNull Consumer<LayoutElement> visitor) {
            this.children().forEach(visitor);
        }

        public void arrangeElements() {
            super.arrangeElements();
            this.clampScrollAmount();
        }

        protected void renderSlidingBackground(@NonNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int paddingX = this.rowGap;
            int minX = this.getX() - paddingX;
            int minY = this.getY() - 2;
            int maxX = this.getRight() + 6;
            int maxY = this.getBottom() + 2;
            guiGraphics.enableScissor(minX, minY, maxX, maxY);
            Entry entry = (Entry)this.getEntryAtPosition(mouseX, mouseY);
            if (entry == null) {
                this.hoveredBackground.reset();
            } else {
                int x = entry.getX() - paddingX;
                int y = entry.getY() - 2;
                int width = entry.getWidth() + paddingX + (this.scrollbarVisible() ? 6 : 2);
                int height = entry.getHeight() + 4;
                this.hoveredBackground.render(guiGraphics, x, y, width, height, partialTick);
            }
            guiGraphics.disableScissor();
        }

        public void renderWidget(@NonNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderSlidingBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }

        private class Entry
        extends AbstractListWidget.Entry
        implements Layout {
            private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
            private final AbstractWidget optionWidget;
            private final AbstractWidget decoration;

            private Entry(@NonNull OptionsList optionsList, @Nullable AbstractWidget optionWidget, AbstractWidget decoration) {
                super(optionsList);
                this.optionWidget = optionWidget;
                this.decoration = decoration;
                if (this.decoration != null) {
                    this.children.add(this.decoration);
                }
                this.children.add(this.optionWidget);
            }

            public void renderContent(@NonNull GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
                this.optionWidget.setPosition(this.getX(), this.getY());
                this.optionWidget.render(guiGraphics, mouseX, mouseY, partialTick);
                if (this.decoration != null) {
                    this.decoration.render(guiGraphics, mouseX, mouseY, partialTick);
                }
            }

            public @NonNull List<AbstractWidget> children() {
                return this.children;
            }

            public @NonNull List<? extends NarratableEntry> narratables() {
                return this.children;
            }

            public void visitChildren(@NonNull Consumer<LayoutElement> visitor) {
                visitor.accept((LayoutElement)this.optionWidget);
            }

            public void visitWidgets(@NonNull Consumer<AbstractWidget> visitor) {
                visitor.accept(this.optionWidget);
            }

            public void arrangeElements() {
                this.optionWidget.setWidth(this.getWidth());
            }
        }
    }
}

