/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import net.minecraft.client.gui.ActiveTextCollector;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ButtonWidget
extends Button.Plain {
    private static final int DEFAULT_SPRITE_SIZE = 16;
    private static final int DISABLED_SPRITE_COLOR = -2136956768;
    private @Nullable Identifier sprite;
    private int textureWidth;
    private int textureHeight;

    public ButtonWidget(int x, int y, int width, int height, Component message, Runnable onPress) {
        super(x, y, width, height, message, btn -> onPress.run(), Button.DEFAULT_NARRATION);
    }

    public ButtonWidget(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, Button.DEFAULT_NARRATION);
    }

    public ButtonWidget(Component message, Runnable onPress) {
        this(0, 0, 150, 20, message, onPress);
    }

    public ButtonWidget(Component message, Button.OnPress onPress) {
        this(0, 0, 150, 20, message, onPress);
    }

    public ButtonWidget withSize(int size) {
        this.setSize(size, size);
        return this;
    }

    public ButtonWidget withTooltip(@Nullable Tooltip tooltip) {
        this.setTooltip(tooltip);
        return this;
    }

    public ButtonWidget withTooltip(@NonNull Component message) {
        this.setTooltip(Tooltip.create((Component)message));
        return this;
    }

    public ButtonWidget spriteOnly(@NonNull Identifier sprite, int textureWidth, int textureHeight) {
        this.sprite = sprite;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        return this;
    }

    public ButtonWidget spriteOnly(@NonNull Identifier sprite) {
        return this.spriteOnly(sprite, 16, 16);
    }

    public void onRelease(@NonNull MouseButtonEvent mouseButtonEvent) {
        this.setFocused(false);
    }

    protected void renderDefaultLabel(@NonNull ActiveTextCollector activeTextCollector) {
        if (this.sprite == null) {
            super.renderDefaultLabel(activeTextCollector);
        }
    }

    protected void renderContents(@NonNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderContents(guiGraphics, mouseX, mouseY, partialTick);
        if (this.sprite != null) {
            int spriteWidth = Math.min(this.getWidth(), this.textureWidth);
            int spriteHeight = Math.min(this.getHeight(), this.textureHeight);
            int spriteX = this.getX() + (this.getWidth() - spriteWidth) / 2;
            int spriteY = this.getY() + (this.getHeight() - spriteHeight) / 2;
            int color = this.active ? -1 : -2136956768;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.sprite, spriteX, spriteY, 0.0f, 0.0f, this.textureWidth, this.textureHeight, spriteWidth, spriteHeight, this.textureWidth, this.textureHeight, color);
        }
    }
}

