/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.gui.widget.AbstractListWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ButtonWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ElementSlidingBackground;
import io.github.fishstiz.cursors_extended.gui.widget.SliderWidget;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class OptionsListWidget
extends AbstractListWidget<AbstractEntry> {
    private static final int BACKGROUND_PADDING_Y = 2;
    private static final int SEARCH_HIGHLIGHT_COLOR = 1728042752;
    private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF);
    private final Font font;
    private @NonNull String search = "";

    public OptionsListWidget(Minecraft minecraft, Font font, int itemHeight, int spacing) {
        super(minecraft, 0, 0, 0, itemHeight, spacing);
        this.font = font;
    }

    public OptionsListWidget(Minecraft minecraft, Font font, int spacing) {
        this(minecraft, font, 20, spacing);
    }

    public void addWidget(AbstractWidget widget) {
        this.addEntry((AbstractSelectionList.Entry)new WidgetEntry(widget));
    }

    public void addToggle(boolean value, Boolean defaultValue, @NonNull Consumer<Boolean> onToggle, @NonNull Component label, @Nullable Tooltip tooltip, BooleanSupplier active) {
        this.addEntry((AbstractSelectionList.Entry)new ToggleEntry(value, defaultValue, onToggle, label, null, tooltip, active));
    }

    public void addToggle(boolean value, Boolean defaultValue, @NonNull Consumer<Boolean> onToggle, @NonNull Component label, @Nullable Tooltip tooltip, boolean active) {
        this.addEntry((AbstractSelectionList.Entry)new ToggleEntry(value, defaultValue, onToggle, label, null, tooltip, () -> active));
    }

    public void addToggle(boolean value, @NonNull Consumer<Boolean> onToggle, @NonNull Component label, @Nullable Tooltip tooltip, boolean active) {
        this.addToggle(value, null, onToggle, label, tooltip, active);
    }

    public void addToggle(boolean value, @NonNull Consumer<Boolean> onToggle, @NonNull Component label, @Nullable Prefix prefix, @Nullable Tooltip tooltip, boolean active) {
        this.addEntry((AbstractSelectionList.Entry)new ToggleEntry(value, onToggle, label, prefix, tooltip, active));
    }

    public void addToggleableSlider(@NonNull SliderWidget slider, boolean value, @NonNull Consumer<Boolean> onToggle, @Nullable Tooltip tooltip) {
        this.addEntry((AbstractSelectionList.Entry)new ToggleableSliderEntry(slider, value, onToggle, tooltip, true));
    }

    public void search(@NonNull String search) {
        this.search = search.toLowerCase();
        if (!this.search.isEmpty()) {
            AbstractEntry bestMatch = null;
            for (AbstractEntry entry : this.children()) {
                String label = entry.indexedLabel;
                if (label.startsWith(this.search)) {
                    bestMatch = entry;
                    break;
                }
                if (bestMatch != null || !label.contains(this.search)) continue;
                bestMatch = entry;
            }
            if (bestMatch != null) {
                this.scrollToEntry((AbstractSelectionList.Entry)bestMatch);
            }
        }
    }

    private int computeBackgroundX(AbstractEntry entry) {
        return entry.getX() - this.rowGap;
    }

    private int computeBackgroundY(AbstractEntry entry) {
        return entry.getY() - 2;
    }

    private int computeBackgroundWidth(AbstractEntry entry) {
        return entry.getWidth() + this.rowGap + (this.scrollbarVisible() ? 6 : 2);
    }

    private int computeBackgroundHeight(AbstractEntry entry) {
        return entry.getHeight() + 4;
    }

    protected void renderSearchBackground(@NonNull GuiGraphics guiGraphics) {
        if (!this.search.isEmpty()) {
            for (AbstractEntry entry : this.children()) {
                if (!entry.indexedLabel.contains(this.search)) continue;
                int bgX = this.computeBackgroundX(entry);
                int bgY = this.computeBackgroundY(entry);
                int bgWidth = this.computeBackgroundWidth(entry);
                int bgHeight = this.computeBackgroundHeight(entry);
                guiGraphics.fill(bgX, bgY, bgX + bgWidth, bgY + bgHeight, 1728042752);
            }
        }
    }

    protected void renderEntryBackground(@NonNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int minX = this.getX() - this.rowGap;
        int minY = this.getY() - 2;
        int maxX = this.getRight() + 6;
        int maxY = this.getBottom() + 2;
        guiGraphics.enableScissor(minX, minY, maxX, maxY);
        this.renderSearchBackground(guiGraphics);
        AbstractEntry entry = (AbstractEntry)this.getEntryAtPosition(mouseX, mouseY);
        if (entry == null) {
            this.hoveredBackground.reset();
        } else {
            int x = this.computeBackgroundX(entry);
            int y = this.computeBackgroundY(entry);
            int width = this.computeBackgroundWidth(entry);
            int height = this.computeBackgroundHeight(entry);
            this.hoveredBackground.render(guiGraphics, x, y, width, height, partialTick);
        }
        guiGraphics.disableScissor();
    }

    public void renderWidget(@NonNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderEntryBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void renderListBackground(@NonNull GuiGraphics guiGraphics) {
    }

    protected void renderListSeparators(@NonNull GuiGraphics guiGraphics) {
    }

    private class WidgetEntry
    extends AbstractEntry {
        private final AbstractWidget widget;

        private WidgetEntry(AbstractWidget widget) {
            super(OptionsListWidget.this, widget.getMessage());
            this.widget = this.addChild(widget);
        }

        @Override
        public void renderContent(@NonNull GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            this.widget.setSize(OptionsListWidget.this.width, this.getHeight());
            this.widget.setPosition(this.getX(), this.getY());
            super.renderContent(guiGraphics, mouseX, mouseY, hovered, partialTick);
        }
    }

    private class ToggleEntry
    extends AbstractEntry {
        protected static final Identifier UNDO_ICON = CursorsExtended.id("textures/gui/sprites/icon/arrow_u_turn_up_left.png");
        protected static final int BUTTON_WIDTH = 40;
        private static final int LABEL_COLOR = -1;
        private static final int DISABLED_COLOR = -5592406;
        private final ButtonWidget button;
        private final ButtonWidget resetButton;
        private final Boolean defaultValue;
        private final Consumer<Boolean> onToggle;
        private final @Nullable Prefix prefix;
        private final BooleanSupplier active;
        protected boolean value;

        private ToggleEntry(boolean value, @NonNull Boolean defaultValue, @NonNull Consumer<Boolean> onToggle, @Nullable Component label, @Nullable Prefix prefix, Tooltip tooltip, BooleanSupplier active) {
            super(OptionsListWidget.this, label);
            this.value = value;
            this.onToggle = onToggle;
            this.active = active;
            this.button = new ButtonWidget(this.getRight() - 40, this.getY(), 40, 20, value ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF, this::onPress);
            this.button.setTooltip(tooltip);
            this.button.active = active.getAsBoolean();
            this.prefix = prefix;
            this.defaultValue = defaultValue;
            if (this.defaultValue != null) {
                this.resetButton = new ButtonWidget((Component)Component.empty(), btn -> {
                    this.value = this.defaultValue;
                    this.updateMessage();
                    this.onToggle.accept(this.defaultValue);
                }).withSize(20).spriteOnly(UNDO_ICON);
                this.resetButton.active = this.button.active && this.value != this.defaultValue;
                this.addChild(this.resetButton);
            } else {
                this.resetButton = null;
            }
            this.addChild(this.button);
        }

        private ToggleEntry(@NonNull boolean value, @NonNull Consumer<Boolean> onToggle, @Nullable Component label, @Nullable Prefix prefix, Tooltip tooltip, boolean active) {
            this(value, null, onToggle, label, prefix, tooltip, () -> active);
        }

        protected void updateMessage() {
            this.button.setMessage(this.value ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
        }

        protected void onPress(Button button) {
            this.value = !this.value;
            this.updateMessage();
            this.onToggle.accept(this.value);
        }

        protected void renderLabel(@NonNull GuiGraphics guiGraphics) {
            int marginX = 0;
            if (this.prefix != null && (marginX = this.prefix.render(guiGraphics, OptionsListWidget.this.font, this.getX(), this.getY(), this.getHeight())) > 0) {
                marginX += OptionsListWidget.this.rowGap;
            }
            int startX = this.getX() + marginX;
            int startY = this.getY();
            int endX = this.button.getX() - OptionsListWidget.this.rowGap;
            int endY = this.getBottom();
            int color = this.active.getAsBoolean() && this.value ? -1 : -5592406;
            DrawUtil.drawScrollableTextLeftAlign(guiGraphics, OptionsListWidget.this.font, this.label, startX, startY, endX, endY, color);
        }

        @Override
        public void renderContent(@NonNull GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            this.button.active = this.active.getAsBoolean();
            int right = this.getRight();
            if (this.resetButton != null) {
                this.resetButton.active = this.button.active && this.value != this.defaultValue;
                this.resetButton.setPosition(right - this.resetButton.getWidth(), this.getY());
                right -= this.resetButton.getWidth() + OptionsListWidget.this.rowGap;
            }
            this.button.setPosition(right - this.button.getWidth(), this.getY());
            this.renderLabel(guiGraphics);
            super.renderContent(guiGraphics, mouseX, mouseY, hovered, partialTick);
        }
    }

    @FunctionalInterface
    public static interface Prefix {
        public int render(@NonNull GuiGraphics var1, Font var2, int var3, int var4, int var5);
    }

    private class ToggleableSliderEntry
    extends ToggleEntry {
        private final SliderWidget slider;

        private ToggleableSliderEntry(SliderWidget slider, @NonNull boolean value, @Nullable Consumer<Boolean> onToggle, Tooltip tooltip, boolean active) {
            super(value, onToggle, slider.getMessage(), null, tooltip, active);
            this.slider = slider;
            this.slider.active = value;
            this.addChild(this.slider);
        }

        @Override
        protected void onPress(Button button) {
            super.onPress(button);
            this.slider.active = this.value;
        }

        @Override
        protected void renderLabel(@NonNull GuiGraphics guiGraphics) {
        }

        @Override
        public void renderContent(@NonNull GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            this.slider.setWidth(OptionsListWidget.this.width - 40 - OptionsListWidget.this.rowGap);
            this.slider.setPosition(this.getX(), this.getY());
            this.slider.render(guiGraphics, mouseX, mouseY, partialTick);
            super.renderContent(guiGraphics, mouseX, mouseY, hovered, partialTick);
        }
    }

    protected abstract class AbstractEntry
    extends AbstractListWidget.Entry {
        protected final Component label;
        private final String indexedLabel;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();

        protected AbstractEntry(OptionsListWidget this$0, Component label) {
            this.label = label;
            this.indexedLabel = label.getString().toLowerCase();
        }

        public void renderContent(@NonNull GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            for (AbstractWidget child : this.children) {
                child.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        protected <T extends AbstractWidget> T addChild(T child) {
            this.children.add(child);
            return child;
        }

        public @NonNull List<AbstractWidget> children() {
            return this.children;
        }

        public @NonNull List<AbstractWidget> narratables() {
            return this.children;
        }
    }
}

