/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jspecify.annotations.NonNull;

public class ToggleWidget
extends Button.Plain {
    private final BiConsumer<ToggleWidget, Boolean> listener;
    private final Component prefix;
    private boolean value;

    public ToggleWidget(int x, int y, int width, int height, boolean value, @NonNull Component prefix, @NonNull BiConsumer<ToggleWidget, Boolean> listener) {
        super(x, y, width, height, prefix, btn -> {}, DEFAULT_NARRATION);
        this.listener = listener;
        this.prefix = prefix;
        this.setValue(value);
    }

    public ToggleWidget(boolean value, @NonNull Component prefix, @NonNull BiConsumer<ToggleWidget, Boolean> listener) {
        this(0, 0, 150, 20, value, prefix, listener);
    }

    public ToggleWidget(boolean value, @NonNull Component prefix, @NonNull Consumer<Boolean> listener) {
        this(0, 0, 150, 20, value, prefix, (target, v) -> listener.accept((Boolean)v));
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        this.value = !this.value;
        this.listener.accept(this, this.value);
        this.updateMessage();
    }

    public void setValue(boolean value) {
        this.value = value;
        this.updateMessage();
    }

    private void updateMessage() {
        this.setMessage((Component)CommonComponents.optionNameValue((Component)this.prefix, (Component)(this.value ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF)));
    }

    public void onRelease(MouseButtonEvent mouseButtonEvent) {
        this.setFocused(false);
    }
}

