/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.resource.texture;

import io.github.fishstiz.cursors_extended.cursor.AnimationMode;
import io.github.fishstiz.cursors_extended.resource.texture.AnimatedCursorTexture;
import java.util.Random;
import net.minecraft.util.Util;

public sealed interface AnimationState {
    public int next(AnimatedCursorTexture var1);

    public void reset();

    public static AnimationState of(AnimationMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case AnimationMode.LOOP, AnimationMode.LOOP_REVERSE -> new Loop();
            case AnimationMode.FORWARDS, AnimationMode.REVERSE -> new Forwards();
            case AnimationMode.OSCILLATE -> new Oscillate();
            case AnimationMode.RANDOM -> new RandomState();
            case AnimationMode.RANDOM_CYCLE -> new RandomCycle();
        };
    }

    public static final class Loop
    extends Base {
        @Override
        public int next(AnimatedCursorTexture texture) {
            if (this.shouldAdvance(texture)) {
                this.updateFrameTime();
                this.currentFrameIndex = (this.currentFrameIndex + 1) % texture.frameCount();
            }
            return this.currentFrameIndex;
        }
    }

    public static final class Forwards
    extends Base {
        @Override
        public int next(AnimatedCursorTexture texture) {
            if (this.shouldAdvance(texture)) {
                this.updateFrameTime();
                this.currentFrameIndex = Math.min(this.currentFrameIndex + 1, texture.frameCount() - 1);
            }
            return this.currentFrameIndex;
        }
    }

    public static final class Oscillate
    extends Base {
        private boolean reversed;

        @Override
        public int next(AnimatedCursorTexture texture) {
            if (this.shouldAdvance(texture)) {
                this.updateFrameTime();
                this.reversed = this.currentFrameIndex != 0 && (this.currentFrameIndex == texture.frameCount() - 1 || this.reversed);
                this.currentFrameIndex = this.reversed ? this.currentFrameIndex - 1 : this.currentFrameIndex + 1;
            }
            return this.currentFrameIndex;
        }

        @Override
        public void reset() {
            super.reset();
            this.reversed = false;
        }
    }

    public static final class RandomState
    extends Base {
        private final Random random = new Random();

        @Override
        public int next(AnimatedCursorTexture texture) {
            if (this.shouldAdvance(texture)) {
                this.updateFrameTime();
                int count = texture.frameCount();
                if (count > 1) {
                    int newFrame;
                    while ((newFrame = this.random.nextInt(count)) == this.currentFrameIndex) {
                    }
                    this.currentFrameIndex = newFrame;
                }
            }
            return this.currentFrameIndex;
        }
    }

    public static final class RandomCycle
    extends Base {
        private final Random random = new Random();
        private int[] shuffledFrames;
        private int shuffledIndex = 0;

        @Override
        public int next(AnimatedCursorTexture texture) {
            if (this.shouldAdvance(texture)) {
                this.updateFrameTime();
                int count = texture.frameCount();
                if (this.shuffledFrames == null || this.shuffledIndex >= count) {
                    this.shuffleFrames(count);
                }
                this.currentFrameIndex = this.shuffledFrames[this.shuffledIndex++];
            }
            return this.currentFrameIndex;
        }

        private void shuffleFrames(int count) {
            int i;
            this.shuffledFrames = new int[count];
            for (i = 0; i < count; ++i) {
                this.shuffledFrames[i] = i;
            }
            for (i = count - 1; i > 0; --i) {
                int j = this.random.nextInt(i + 1);
                int tmp = this.shuffledFrames[i];
                this.shuffledFrames[i] = this.shuffledFrames[j];
                this.shuffledFrames[j] = tmp;
            }
            this.shuffledIndex = 0;
        }

        @Override
        public void reset() {
            super.reset();
            this.shuffledFrames = null;
            this.shuffledIndex = 0;
        }
    }

    public static abstract sealed class Base
    implements AnimationState
    permits Loop, Forwards, Oscillate, RandomState, RandomCycle {
        protected static final long MS_PER_TICK = 50L;
        protected int currentFrameIndex;
        protected long lastFrameTime;

        protected boolean shouldAdvance(AnimatedCursorTexture texture) {
            AnimatedCursorTexture.Frame currentFrame = texture.getFrame(this.currentFrameIndex);
            long currentTime = Util.getMillis();
            return currentTime - this.lastFrameTime >= (long)currentFrame.time() * 50L;
        }

        protected void updateFrameTime() {
            this.lastFrameTime = Util.getMillis();
        }

        @Override
        public void reset() {
            this.lastFrameTime = Util.getMillis();
            this.currentFrameIndex = 0;
        }
    }
}

