/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.resource.texture;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.fishstiz.cursors_extended.config.CursorMetadata;
import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.resource.texture.AbstractCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.NativeImageUtil;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import java.io.IOException;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.NonNull;

public final class BasicCursorTexture
extends AbstractCursorTexture {
    private final float scale;
    private final int xhot;
    private final int yhot;
    private final int textureWidth;
    private final int textureHeight;
    private final byte[] pixels;
    private final Identifier texturePath;
    private final CursorMetadata metadata;

    public BasicCursorTexture(NativeImage image, Identifier texturePath, CursorMetadata metadata, CursorProperties settings) throws IOException {
        super(image, settings);
        this.scale = SettingsUtil.sanitizeScale(settings.scale());
        this.xhot = SettingsUtil.sanitizeHotspot(settings.xhot(), image.getWidth());
        this.yhot = SettingsUtil.sanitizeHotspot(settings.yhot(), image.getHeight());
        this.textureWidth = image.getWidth();
        this.textureHeight = image.getHeight();
        this.pixels = NativeImageUtil.getBytes(image);
        this.texturePath = texturePath;
        this.metadata = metadata;
    }

    @Override
    public float scale() {
        return this.scale;
    }

    @Override
    public int xhot() {
        return this.xhot;
    }

    @Override
    public int yhot() {
        return this.yhot;
    }

    @Override
    public int textureWidth() {
        return this.textureWidth;
    }

    @Override
    public int textureHeight() {
        return this.textureHeight;
    }

    @Override
    public CursorMetadata metadata() {
        return this.metadata;
    }

    public @NonNull Identifier texturePath() {
        return this.texturePath;
    }

    @Override
    public CursorTexture recreate(CursorProperties properties) throws IOException {
        try (NativeImage image = NativeImage.read((byte[])this.pixels);){
            BasicCursorTexture basicCursorTexture = new BasicCursorTexture(image, this.texturePath, this.metadata, properties);
            return basicCursorTexture;
        }
    }
}

