package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorHandler;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.mixin.access.BookEditScreenAccessor;
import net.minecraft.class_473;

public class BookEditScreenCursorHandler implements CursorHandler<class_473> {
    // Manually set values from testing in game
    public static final int MAX_POS_X = 115;
    public static final int MAX_POS_Y = 125;

    @Override
    public CursorType getCursorType(class_473 element, double mouseX, double mouseY) {
        if (!MinecraftCursor.CONFIG.isBookEditEnabled()) return CursorType.DEFAULT;

        BookEditScreenAccessor bookEditScreen = (BookEditScreenAccessor) element;

        if (bookEditScreen.getFinalizeButton().field_22764) return CursorType.DEFAULT;

        class_473.class_5234 position =
                bookEditScreen.invokeScreenPosToAbsPos(new class_473.class_5234((int) mouseX, (int) mouseY));
        if (position.field_24282 >= 0 && position.field_24282 <= MAX_POS_Y && position.field_24281 > 0 && position.field_24281 <= MAX_POS_X) {
            return CursorType.TEXT;
        }
        return CursorType.DEFAULT;
    }
}
