package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.cursorhandler.AbstractHandledScreenCursorHandler;
import io.github.fishstiz.minecraftcursor.provider.HandledScreenCursorProvider;
import io.github.fishstiz.minecraftcursor.mixin.access.HandledScreenAccessor;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_465;

import static io.github.fishstiz.minecraftcursor.MinecraftCursor.CONFIG;

public class HandledScreenCursorHandler<T extends class_1703, U extends class_465<? extends T>> extends AbstractHandledScreenCursorHandler<T, U> {
    @Override
    public CursorType getCursorType(U handledScreen, double mouseX, double mouseY) {
        CursorType cursorType = computeCursorType(handledScreen);
        HandledScreenCursorProvider.setCursorType(cursorType);
        return cursorType;
    }

    private CursorType computeCursorType(U handledScreen) {
        class_1703 handler = ((HandledScreenAccessor<?>) handledScreen).getHandler();
        class_1735 focusedSlot = ((HandledScreenAccessor<?>) handledScreen).getFocusedSlot();

        boolean canClickFocusedSlot = handler.method_34255().method_7960()
                && focusedSlot != null
                && focusedSlot.method_7681()
                && focusedSlot.method_51306();

        if (canClickFocusedSlot && CursorTypeUtil.canShift()) {
            return CursorType.SHIFT;
        }
        if (CONFIG.isItemSlotEnabled() && canClickFocusedSlot) {
            return CursorType.POINTER;
        }
        if (CONFIG.isItemGrabbingEnabled() && !handler.method_34255().method_7960()) {
            return CursorType.GRABBING;
        }
        return CursorType.DEFAULT;
    }
}
