package io.github.fishstiz.minecraftcursor.cursorhandler.multiplayer;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorHandler;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import net.minecraft.class_4267;

public class MultiplayerServerListWidgetCursorHandler implements CursorHandler<class_4267> {
    public static final int ICON_SIZE = 32;

    @Override
    public CursorType getCursorType(class_4267 serverList, double mouseX, double mouseY) {
        if (!MinecraftCursor.CONFIG.isServerIconEnabled()) return CursorType.DEFAULT;

        class_4267.class_4270 serverEntry =
                (class_4267.class_4270) serverList.method_19355(mouseX, mouseY)
                        .filter(entry -> entry instanceof class_4267.class_4270)
                        .orElse(null);
        if (serverEntry != null && mouseX >= serverList.method_25342() && mouseX <= serverList.method_25342() + ICON_SIZE) {
            return CursorType.POINTER;
        }
        return CursorType.DEFAULT;
    }
}
